/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.presentation.client.ui.presenters;

import com.freiheit.toro.client.event.GlobalEventManager;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ui.editor.EditorClientFactory;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.multiwiki.presentation.client.MultiWikiComponentFactory;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiEditorPresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiSectionHeadlinePresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiSectionPresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiSectionVisibilitiesPresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiSectionView;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionChangedEditModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionClientModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionEditModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionUnchangedEditModel;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MultiWikiSectionPresenter
implements MultiWikiSectionView.Presenter {
    public static final Function<MultiWikiSectionPresenter, MultiWikiSectionEditModel> TO_EDIT_MODEL = new /* Unavailable Anonymous Inner Class!! */;
    private final MultiWikiComponentFactory _componentFactory;
    private final MultiWikiSectionView _view;
    private final MultiWikiEditorPresenter _editorPresenter;
    private final EditorClientFactory _editorFactory;
    private final MultiWikiEditorPresenter.EditHandler _editHandler;
    private boolean _editable;
    private MultiWikiSectionHeadlinePresenter _headingPresenter;
    private MultiWikiSectionVisibilitiesPresenter _visibilitiesPresenter;
    private MultiWikiSectionEditHandler _multiWikiSectionEditHandler;
    private MultiWikiSectionClientModel _section;
    private HasWidgets.ForIsWidget _container;
    private boolean _folded;
    private final ImmutableList<AuthorityModel> _availableRoles;

    public MultiWikiSectionPresenter(MultiWikiComponentFactory componentFactory, MultiWikiId multiWikiId, EditorClientFactory editorFactory, MultiWikiSectionClientModel section, String editorToolbar, MultiWikiEditorPresenter.EditHandler editHandler, boolean mayEdit, boolean folded, ImmutableList<AuthorityModel> availableRoles) {
        this._componentFactory = componentFactory;
        this._availableRoles = availableRoles;
        this._editHandler = editHandler;
        this._editorFactory = editorFactory;
        this._section = section;
        this._editable = mayEdit;
        this._view = this._componentFactory.sectionView((MultiWikiSectionView.Presenter)this);
        this.setFolded(folded);
        this._editorPresenter = componentFactory.editorPresenter(editorFactory, (GlobalId)multiWikiId, section.getText(), editorToolbar, editHandler, this._editable);
        this._editorPresenter.showIn(this._view.getEditorContainer());
        this.initializeChildPresenters();
        this.setSection(section);
    }

    private void initializeChildPresenters() {
        this._headingPresenter = this._componentFactory.sectionHeadlinePresenter(this._editorFactory, this._section.getHeadline(), this._editable, this._editHandler);
        this._headingPresenter.showIn(this._view.getHeadlineContainer());
        this._visibilitiesPresenter = this._componentFactory.sectionVisibilityPresenter(this._editorFactory, this._section.getSelectedRolesAllowedToRead(), this._editable, this._editHandler, this._availableRoles);
        this._visibilitiesPresenter.showIn(this._view.getVisibilityContainer());
    }

    public void setSectionEditHandler(MultiWikiSectionEditHandler multiWikiSectionEditHandler) {
        this._multiWikiSectionEditHandler = multiWikiSectionEditHandler;
    }

    public void showIn(HasWidgets.ForIsWidget container) {
        this._container = container;
        this._container.add((IsWidget)this._view);
    }

    public void onFold() {
        this.setFolded(!this._folded);
    }

    private void setFolded(boolean fold) {
        this._folded = fold;
        this._view.setFoldIconType(this._folded ? IconType.CHEVRON_RIGHT : IconType.CHEVRON_DOWN);
        this._view.setContentVisible(!this._folded);
    }

    public void cancelEditing() {
        this._editorPresenter.onCancel();
        this._headingPresenter.cancel();
    }

    public void setSection(MultiWikiSectionClientModel newSection) {
        this._section = newSection;
        this._editorPresenter.setContent(this._section.getText());
        this._headingPresenter.setHeadline(this._section.getHeadline());
        this._visibilitiesPresenter.setVisibilities(this._section.getSelectedRolesAllowedToRead());
    }

    public void startEditing() {
        this.setFolded(false);
        this._headingPresenter.edit();
    }

    public boolean isDirty() {
        return this._section.getId() == null || this._editorPresenter.isDirty() || this._headingPresenter.isDirty() || this._visibilitiesPresenter.isDirty();
    }

    @Nonnull
    public MultiWikiSectionEditModel getEditModel() {
        boolean dirty = this.isDirty();
        if (dirty) {
            return new MultiWikiSectionChangedEditModel(this._section.getId(), this._headingPresenter.getValue(), this._editorPresenter.getContent(), ImmutableList.copyOf((Collection)this._visibilitiesPresenter.getSelectedRoles()));
        }
        return new MultiWikiSectionUnchangedEditModel(this._section.getId());
    }

    @Nonnull
    public MultiWikiSectionClientModel getSection() {
        return this._section;
    }

    @Nonnull
    public MultiWikiSectionId getId() {
        return this._section.getId();
    }

    public void removeFromParent() {
        if (this._container == null) {
            return;
        }
        this._container.remove((IsWidget)this._view);
    }

    public void onMoveUp() {
        if (this._multiWikiSectionEditHandler != null) {
            this._multiWikiSectionEditHandler.onMoveUp();
        }
    }

    public void onMoveDown() {
        if (this._multiWikiSectionEditHandler != null) {
            this._multiWikiSectionEditHandler.onMoveDown();
        }
    }

    public void onDelete() {
        if (this._multiWikiSectionEditHandler != null) {
            this._multiWikiSectionEditHandler.onDelete();
        }
    }

    public void setEditable(boolean editable) {
        if (this._editable == editable) {
            return;
        }
        this._editable = editable;
        this._editorPresenter.setEditable(editable);
        this.initializeChildPresenters();
    }

    public void setMoveUpEnabled(boolean enabled) {
        this._view.setMoveUpEnabled(enabled);
    }

    public void setMoveDownEnabled(boolean enabled) {
        this._view.setMoveDownEnabled(enabled);
    }

    public void setMoveActionsVisible(boolean visible) {
        this._view.setMoveActionsVisible(visible);
    }

    public void setDeleteEnabled(boolean enabled) {
        this._view.setDeleteEnabled(enabled);
    }

    public void setDeleteActionVisible(boolean visible) {
        this._view.setDeleteActionVisible(visible);
    }

    public void scrollTo() {
        this.setFolded(false);
        this._view.openParentsAndScrollTo(null);
        GlobalEventManager.getInstance().fireAdjustEntityScrollPosition(0);
    }

    public void scrollTo(int headingPosition) {
        this.setFolded(false);
        Element headingElement = this._view.getHeadingElement(headingPosition);
        if (headingElement != null) {
            this._view.openParentsAndScrollTo(headingElement);
            GlobalEventManager.getInstance().fireAdjustEntityScrollPosition(0);
        }
    }

    public void openSection() {
        this.setFolded(false);
    }

    public void editContent(@Nullable Runnable callback) {
        this._editorPresenter.startEditing(callback);
    }

    public void focus() {
        this._editorPresenter.focus();
    }
}

