/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.presentation.client.ui.presenters;

import com.freiheit.toro.client.event.GlobalEventManager;
import com.freiheit.toro.client.mediator.HistoryManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.events.ClientEvent;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.FullscreenView;
import de.justsoftware.onx.common.presentation.client.ui.PlaceHolder;
import de.justsoftware.onx.common.presentation.client.ui.editor.ButtonBarView;
import de.justsoftware.onx.common.presentation.client.ui.editor.EditorClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.editor.LockHandler;
import de.justsoftware.onx.common.presentation.client.ui.editor.LockOwner;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.common.shared.util.Runnables2;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.multiwiki.presentation.client.MultiWikiComponentFactory;
import de.justsoftware.onx.multiwiki.presentation.client.MultiWikiRoleSelectedEvent;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiEditorPresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiFullscreenPresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiSectionPresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiTOCPresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.presenters.MultiWikiViewAsRolePresenter;
import de.justsoftware.onx.multiwiki.presentation.client.ui.views.MultiWikiView;
import de.justsoftware.onx.multiwiki.presentation.shared.MultiWikiControllerAsync;
import de.justsoftware.onx.multiwiki.shared.i18n.MultiWikiMessages;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiClientModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionClientModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionEditModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MultiWikiPresenter
implements MultiWikiView.Presenter,
MultiWikiEditorPresenter.EditHandler,
ButtonBarView.Presenter,
MultiWikiTOCPresenter.ScrollHandler,
MultiWikiViewAsRolePresenter.ViewAsRoleChangeHandler,
FullscreenView.OnFullscreenClosedCallback {
    private static final int MULTI_WIKI_EDIT_LINK_POS = 1;
    private final MultiWikiSectionEditModel.MultiWikiSectionEditModelVisitor<MultiWikiSectionClientModel> _editModelConverter = new /* Unavailable Anonymous Inner Class!! */;
    private final MultiWikiComponentFactory _componentFactory;
    private final EntityConstants _entityConstants;
    private final EventManager _eventManager;
    private final MultiWikiControllerAsync _controller;
    private MultiWikiClientModel _wiki;
    private final String _toolbar;
    private final LockHandler _lockHandler;
    private final MultiWikiView _view;
    private final MultiWikiViewAsRolePresenter _viewAsRolePresenter;
    private final MultiWikiTOCPresenter _tocPresenter;
    private final List<MultiWikiSectionPresenter> _sectionPresenters = new ArrayList();
    private final ButtonBarView _buttonBarView;
    private String _viewAsRole = null;
    private final EntityId _parentId;
    private final GlobalEventManager _globalEventManager;
    private final MultiWikiMessages _multiWikiMessages;
    private boolean _moveSectionInProgress = false;

    public MultiWikiPresenter(MultiWikiComponentFactory componentFactory, EntityConstants entityConstants, MultiWikiControllerAsync controller, EditorClientFactory editorFactory, MultiWikiClientModel wiki, EntityId parentId, String toolbar, boolean browserSearchEnabled, HistoryManager historyManager, GlobalEventManager globalEventManager, MultiWikiMessages i18n) {
        this._componentFactory = componentFactory;
        this._entityConstants = entityConstants;
        this._eventManager = this._componentFactory.eventManager();
        this._controller = controller;
        this._wiki = wiki;
        this._toolbar = toolbar;
        this._globalEventManager = globalEventManager;
        this._lockHandler = new LockHandler(editorFactory.lockManager(), LockOwner.MULTI_WIKI_COMPONENT);
        this._view = this._componentFactory.multiWikiView((MultiWikiView.Presenter)this, browserSearchEnabled);
        this._viewAsRole = this._wiki.getViewedAsRole();
        this._viewAsRolePresenter = this._componentFactory.viewAsRolePresenter((MultiWikiViewAsRolePresenter.ViewAsRoleChangeHandler)this);
        this._viewAsRolePresenter.init(FluentIterable.from((Iterable)this._wiki.getRolesForViewAs()).transform(AuthorityModel.TO_NAME).toSet(), this._wiki.getViewedAsRole());
        this._viewAsRolePresenter.showIn(this._view.getViewAsContainer());
        this._tocPresenter = this._componentFactory.tocPresenter((MultiWikiTOCPresenter.ScrollHandler)this, this._wiki.getTocType());
        this._tocPresenter.setSections(this._wiki.getSections());
        this._tocPresenter.showIn(this._view.getTOCContainer());
        this._buttonBarView = editorFactory.getButtonBarView((ButtonBarView.Presenter)this);
        this._buttonBarView.setSaveButtonEnabled(false);
        this._buttonBarView.setNotificationCheckBoxVisible(false);
        this._parentId = parentId;
        this._multiWikiMessages = i18n;
        this.initSectionPresenters();
        if (this.mayEditWiki()) {
            this._globalEventManager.fireRenderWikiEditLink(StaticComponentType.MULTI_WIKI.getName(), () -> this.onEdit(null), this._multiWikiMessages.edit(), 1);
        }
        historyManager.confirmNextHistoryChange(() -> this.isDirty());
    }

    @Nonnull
    private MultiWikiSectionPresenter createSectionPresenter(MultiWikiSectionClientModel section, boolean folded) {
        MultiWikiSectionPresenter presenter = this._componentFactory.sectionPresenter(section, this._wiki.getId(), this._toolbar, (MultiWikiEditorPresenter.EditHandler)this, this.mayEditWiki(), folded, this._wiki.getRolesForSectionRead());
        presenter.setSectionEditHandler((MultiWikiSectionPresenter.MultiWikiSectionEditHandler)new /* Unavailable Anonymous Inner Class!! */);
        return presenter;
    }

    private void initSectionActions() {
        boolean deleteEnabled = this._sectionPresenters.size() > 1;
        boolean mayEditWiki = this.mayEditWiki();
        for (int i = 0; i < this._sectionPresenters.size(); ++i) {
            boolean moveUpEnabled = i > 0;
            boolean moveDownEnabled = i < this._sectionPresenters.size() - 1;
            MultiWikiSectionPresenter presenter = (MultiWikiSectionPresenter)this._sectionPresenters.get(i);
            presenter.setEditable(mayEditWiki);
            presenter.setMoveActionsVisible(mayEditWiki && (moveUpEnabled || moveDownEnabled));
            presenter.setMoveDownEnabled(moveDownEnabled);
            presenter.setMoveUpEnabled(moveUpEnabled);
            presenter.setDeleteActionVisible(mayEditWiki && deleteEnabled);
            presenter.setDeleteEnabled(deleteEnabled);
        }
    }

    private void updateView() {
        this._view.setAddSectionVisible(this.mayEditWiki() && this._sectionPresenters.size() < this._wiki.getMaxSections());
        this.initSectionActions();
    }

    private boolean mayEditWiki() {
        return this._wiki.getPermissions().contains((Object)StaticAction.MULTI_WIKI_SAVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapSections(int oldSectionIndex, int newSectionIndex) {
        if (oldSectionIndex >= 0 && oldSectionIndex < this._sectionPresenters.size() && newSectionIndex >= 0 && newSectionIndex < this._sectionPresenters.size()) {
            Collections.swap(this._sectionPresenters, oldSectionIndex, newSectionIndex);
        }
        try {
            this._moveSectionInProgress = true;
            this._view.getSectionsContainer().clear();
            for (MultiWikiSectionPresenter presenter : this._sectionPresenters) {
                presenter.showIn(this._view.getSectionsContainer());
            }
        }
        finally {
            this._moveSectionInProgress = false;
        }
        this.refreshTOC();
        this.initSectionActions();
    }

    private void refreshTOC() {
        ImmutableList newSectionModels = FluentIterable.from((Iterable)this._sectionPresenters).transform((Function)new /* Unavailable Anonymous Inner Class!! */).filter(Predicates.notNull()).toList();
        this._tocPresenter.setSections(newSectionModels);
    }

    public void showIn(PlaceHolder placeHolder) {
        placeHolder.replace((IsWidget)this._view.asWidget());
        this._eventManager.handleEvent((ClientEvent)new MultiWikiRoleSelectedEvent(null));
    }

    public void showIn(AcceptsOneWidget parentWidget) {
        parentWidget.setWidget((IsWidget)this._view.asWidget());
    }

    public void onSave(boolean sendNotificationToSubscribers) {
        this._view.setProgressIndicatorVisibility(true);
        this._viewAsRolePresenter.setEnabled(true);
        ImmutableList editModels = FluentIterable.from((Iterable)this._sectionPresenters).transform(MultiWikiSectionPresenter.TO_EDIT_MODEL).toList();
        this._controller.saveMultiWiki(this._wiki.getId(), this._wiki.getVersionId(), editModels, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean onEdit(Runnable callback) {
        if (this._lockHandler.isLockedByMe()) {
            if (callback != null) {
                callback.run();
            }
            return true;
        }
        if (!this._lockHandler.tryLock()) {
            return false;
        }
        Runnables2.afterAll((Runnable)callback, rs -> {
            for (MultiWikiSectionPresenter p : Lists.reverse((List)this._sectionPresenters)) {
                p.editContent((Runnable)rs.get());
            }
        });
        this._globalEventManager.fireDeactivateWikiEditLink();
        this._viewAsRolePresenter.setEnabled(false);
        this._view.getButtonBarContainer().setWidget((IsWidget)this._buttonBarView);
        return true;
    }

    public boolean clearOnUnload() {
        return !this._moveSectionInProgress;
    }

    public boolean resetOnLoad() {
        return !this._moveSectionInProgress;
    }

    private void setDirty(boolean dirty) {
        this._buttonBarView.setSaveButtonEnabled(dirty);
    }

    public void onCancel() {
        this._globalEventManager.fireActivateWikiEditLink();
        this._buttonBarView.removeFromParent();
        this._buttonBarView.setSaveButtonEnabled(false);
        this._lockHandler.freeLock();
        this._viewAsRolePresenter.setEnabled(true);
        this.initSectionPresenters();
        this.refreshTOC();
    }

    private void initSectionPresenters() {
        ImmutableList sections = this._wiki.getSections();
        for (int sectionIndex = 0; sectionIndex < sections.size(); ++sectionIndex) {
            MultiWikiSectionClientModel section = (MultiWikiSectionClientModel)sections.get(sectionIndex);
            MultiWikiSectionPresenter presenter = (MultiWikiSectionPresenter)Iterables.get((Iterable)this._sectionPresenters, (int)sectionIndex, null);
            if (presenter != null) {
                presenter.cancelEditing();
                presenter.setSection(section);
                continue;
            }
            presenter = this.createSectionPresenter(section, sectionIndex > 0);
            this._sectionPresenters.add(presenter);
            presenter.showIn(this._view.getSectionsContainer());
        }
        if (this._sectionPresenters.size() > sections.size()) {
            List toRemove = this._sectionPresenters.subList(this._wiki.getSections().size(), this._sectionPresenters.size());
            for (MultiWikiSectionPresenter multiWikiSectionPresenter : toRemove) {
                multiWikiSectionPresenter.cancelEditing();
                multiWikiSectionPresenter.removeFromParent();
            }
            this._sectionPresenters.removeAll(toRemove);
        }
        this.updateView();
    }

    public void onAddSection() {
        MultiWikiSectionPresenter presenter = this.createSectionPresenter(new MultiWikiSectionClientModel(null, this._entityConstants.defaultMultiWikiSectionHeadline(), this._entityConstants.defaultMultiWikiSectionText(), this._wiki.getDefaultRolesForSectionRead(), this._wiki.getVersionId()), false);
        this._sectionPresenters.add(presenter);
        this._buttonBarView.setSaveButtonEnabled(true);
        presenter.showIn(this._view.getSectionsContainer());
        presenter.startEditing();
        presenter.editContent(() -> ((MultiWikiSectionPresenter)presenter).focus());
        this.updateView();
        this.refreshTOC();
    }

    @Nonnull
    private MultiWikiSectionPresenter findPresenter(MultiWikiSectionId sectionId) {
        MultiWikiSectionPresenter presenter = (MultiWikiSectionPresenter)Iterators.find(this._sectionPresenters.iterator(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        return presenter;
    }

    @CheckForNull
    private MultiWikiSectionPresenter findPresenter(int sectionIndex) {
        if (sectionIndex < 0 || sectionIndex >= this._sectionPresenters.size()) {
            return null;
        }
        return (MultiWikiSectionPresenter)this._sectionPresenters.get(sectionIndex);
    }

    public void scrollTo(int sectionIndex) {
        MultiWikiSectionPresenter presenter = this.findPresenter(sectionIndex);
        if (presenter == null) {
            return;
        }
        presenter.scrollTo();
    }

    public void scrollTo(MultiWikiSectionId sectionId, int index) {
        this.findPresenter(sectionId).scrollTo(index);
    }

    public void viewAsRole(String role) {
        this._viewAsRole = role;
        this.reloadView();
    }

    protected void reloadView() {
        this._view.setProgressIndicatorVisibility(true);
        this._controller.loadCurrentWiki(this._wiki.getId(), this._viewAsRole, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onChange() {
        this.setDirty(this.isDirty());
    }

    public void onShowFullscreen() {
        if (this.isDirty()) {
            this._componentFactory.overlayNotificationListPresenter().addNotification(this._componentFactory.multiWikiMessages().saveOrDiscardChanges());
            return;
        }
        MultiWikiFullscreenPresenter fullscreenPresenter = this._componentFactory.multiWikiFullscreenPresenter((FullscreenView.OnFullscreenClosedCallback)this, this._wiki, this._parentId, this._entityConstants, this._toolbar);
        fullscreenPresenter.show();
    }

    public void handleFullscreenClosed() {
        this.reloadView();
    }

    public boolean isDirty() {
        for (MultiWikiSectionPresenter sectionPresenter : this._sectionPresenters) {
            if (!sectionPresenter.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void onUnload() {
        this._lockHandler.freeLock();
        this._globalEventManager.fireRemoveWikiEditLink(StaticComponentType.MULTI_WIKI.getName());
    }
}

