/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.menu.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.github.gwtbootstrap.client.ui.NavList;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.common.presentation.client.ui.JCNavWidget;
import de.justsoftware.onx.menu.presentation.client.ui.HasMenuIconLinks;
import de.justsoftware.onx.menu.shared.model.ExpandStatus;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MenuIconLink
extends JCNavWidget
implements HasMenuIconLinks {
    public static final String SUBLIST_COLLAPSED_CSS_CLASS = "sublist-collapsed";
    public static final String SUBLIST_EXPANDED_CSS_CLASS = "sublist-expanded";
    private static final String HIDE_ICON_CSS_CLASS = "hide-menu-icon";
    private static final String HAS_CHILDREN = "has-sublist-entries";
    private NavList _subList = null;
    private final ExpandStatus _expandStatus;
    private JCIconOnlyAnchor _expandIcon;
    private boolean _expanded = false;
    private final FlowPanel _menuIconWrapper;
    private final IconAnchor _menuIconAnchor;

    public MenuIconLink(@Nullable IconType iconType, @Nonnull String text, @Nonnull String token, @Nonnull ExpandStatus expandStatus, boolean hasChildren) {
        this(iconType, text, expandStatus, hasChildren);
        this.setTargetHistoryToken(token);
    }

    public MenuIconLink(@Nullable IconType iconType, @Nonnull String text, @Nonnull ExpandStatus expandStatus, boolean hasChildren) {
        this.setIcon(iconType);
        this.setText(text);
        this.setTitle(text);
        this._expandStatus = expandStatus;
        this._menuIconWrapper = new FlowPanel();
        this._menuIconWrapper.addStyleName("nav-menu-icon-wrapper");
        this.addWidget((Widget)this._menuIconWrapper);
        this._menuIconAnchor = this.getAnchor();
        this._menuIconAnchor.addStyleName("nav-menu-icon-anchor");
        this._menuIconWrapper.add((Widget)this._menuIconAnchor);
        this.setStyleName(HAS_CHILDREN, hasChildren);
    }

    private void setExpanded(boolean expanded) {
        boolean bl = this._expanded = this._expandStatus == ExpandStatus.ALWAYS_EXPANDED || expanded;
        if (this._expandIcon != null) {
            this._expandIcon.setIcon(this._expanded ? IconType.CHEVRON_DOWN : IconType.CHEVRON_RIGHT);
            this._expandIcon.setTitle(this._expanded ? I18nMediator.BASIC_CONSTANTS.collapseNavMenu() : I18nMediator.BASIC_CONSTANTS.expandNavMenu());
        }
        this.setStyleName(SUBLIST_COLLAPSED_CSS_CLASS, !this._expanded);
        this.setStyleName(SUBLIST_EXPANDED_CSS_CLASS, this._expanded);
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void addMenuIconLink(MenuIconLink menuIconLink) {
        if (this._subList == null) {
            this._subList = new NavList();
            this._subList.addStyleName("nav-sub-list");
            if (this._expandStatus != ExpandStatus.ALWAYS_EXPANDED) {
                this._expandIcon = new JCIconOnlyAnchor();
                this._expandIcon.addStyleName("nav-expand-icon");
                this._expandIcon.setCustomIconStyle("icon-fixed-width");
                this._expandIcon.addClickHandler(event -> this.setExpanded(!this._expanded));
                this._menuIconWrapper.add((Widget)this._expandIcon);
                this._menuIconWrapper.addStyleName("has-expand-icon");
            }
            this.setExpanded(this._expandStatus != ExpandStatus.COLLAPSED);
            super.addWidget((Widget)this._subList);
        }
        this._subList.add((Widget)menuIconLink);
    }

    public void addIconWrapperStyleName(@Nonnull String styleName) {
        this._menuIconWrapper.addStyleName(styleName);
    }

    public void addIcon(@Nonnull IsWidget icon) {
        this._menuIconWrapper.add(icon);
    }

    public void setIconVisible(boolean visible) {
        this._menuIconAnchor.setStyleName(HIDE_ICON_CSS_CLASS, !visible);
    }
}

