/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.hierarchy.presentation.client.impl;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.EntityComponentHandler;
import de.justsoftware.onx.common.presentation.client.ui.PlaceHolder;
import de.justsoftware.onx.common.shared.model.ComponentModel;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.presentation.client.ui.ComponentConfiguratorWidget;
import de.justsoftware.onx.container.presentation.shared.model.entityedit.ComponentConfigurationEntityEditModel;
import de.justsoftware.onx.container.shared.model.ComponentPositionConfig;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ModuleData;
import de.justsoftware.onx.hierarchy.shared.model.HierarchyModuleData;
import javax.annotation.Nonnull;

public class HierarchyEntityComponentHandler
implements EntityComponentHandler {
    private final ClientFactory _clientFactory;

    public HierarchyEntityComponentHandler(@Nonnull ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
    }

    public void getEntityComponentWidget(ClientFactory clientFactory, PlaceHolder placeHolder, ComponentModel componentModel, EntityDetails entity) {
        ModuleData moduleData = componentModel.getModuleData();
        if (moduleData instanceof HierarchyModuleData) {
            String customizedTitle = componentModel.getPositionConfig().getCustomizedTitle();
            EntityType type = entity.getType();
            placeHolder.replace((IsWidget)this._clientFactory.hierarchyClientFactory().createHierarchyModuleWidget(StringUtil.isBlank((String)customizedTitle) ? this.getDefaultTitle(type) : customizedTitle, (HierarchyModuleData)moduleData, type, entity.getId()));
        }
    }

    public ComponentConfiguratorWidget getEntityComponentConfigWidget(ComponentPositionConfig componentPositionConfig, EntityId entityId, ComponentConfigurationEntityEditModel entityEditModel) {
        return ComponentConfiguratorWidget.withoutRoleConfig((String)this.getDefaultTitle(entityEditModel.getEntityType()), (ComponentPositionConfig)componentPositionConfig, (ComponentConfigurationEntityEditModel)entityEditModel, (boolean)true);
    }

    @Nonnull
    private String getDefaultTitle(@Nonnull EntityType entityType) {
        return I18nMediator.getEntityConstantsByEntityType((EntityType)entityType).childHierarchy();
    }
}

