/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.shared;

import com.freiheit.toro.account.presentation.ui.LoginManagerImpl;
import com.freiheit.toro.util.client.LoggingUtil;
import com.google.common.base.Strings;
import com.google.gwt.dom.client.Element;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONBoolean;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.comments.presentation.client.ui.CommentListWidget;
import de.justsoftware.onx.comments.shared.model.HasComments;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.events.ClientEvent;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.container.presentation.client.MyEntitySubscriptionsChangedEvent;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class JavascriptToGwt {
    private static final List<Panel> WIDGETS = new ArrayList();

    @Nonnull
    private static Object[] convertParamsFromJSONArray(@Nullable JSONArray array) {
        if (array == null) {
            return new Object[0];
        }
        Object[] result = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            JSONValue value = array.get(i);
            JSONString string = value.isString();
            if (string != null) {
                result[i] = string.stringValue();
                continue;
            }
            JSONNumber number = value.isNumber();
            if (number != null) {
                result[i] = Double.valueOf(number.doubleValue()).longValue();
                continue;
            }
            JSONBoolean bool = value.isBoolean();
            if (bool != null) {
                result[i] = bool.booleanValue();
                continue;
            }
            if (value.isNull() != null) {
                result[i] = null;
                continue;
            }
            throw new IllegalArgumentException("'" + value.toString() + "' at postion " + i + " is not a String, Long, Boolean or null!");
        }
        return result;
    }

    @CheckForNull
    public static String getHistoryToken(String token, @Nullable String paramsJsonArray) {
        HistoryToken hToken = HistoryToken.fromString((String)token);
        if (hToken == null) {
            LoggingUtil.error(JavascriptToGwt.class, (String)("No HistoryToken '" + token + "' exists."));
            return null;
        }
        Object[] params = JavascriptToGwt.convertParamsFromJSONArray(Strings.isNullOrEmpty((String)paramsJsonArray) ? null : JSONParser.parseStrict((String)paramsJsonArray).isArray());
        return ClientFactoryImpl.INSTANCE.historyManager().createHistoryItem(hToken, params);
    }

    public static void gotoHistoryToken(String token, @Nullable String paramsJsonArray, boolean replace) {
        String hToken = JavascriptToGwt.getHistoryToken((String)token, (String)paramsJsonArray);
        if (hToken == null) {
            return;
        }
        if (replace) {
            History.replaceItem((String)hToken);
        } else {
            History.newItem((String)hToken);
        }
    }

    @CheckForNull
    public static String getCurrentPersonId() {
        PersonId personId = LoginManagerImpl.getInstance().getPersonId();
        return personId != null ? Long.toString(personId.getId()) : null;
    }

    public static void setPageTitle(String pageTitle) {
        ClientFactoryImpl.INSTANCE.pageTitleService().setPageTitle(pageTitle);
    }

    public static void setTemporaryPageTitle(String pageTitle) {
        ClientFactoryImpl.INSTANCE.pageTitleService().setTemporaryTitle(pageTitle);
    }

    public static void resetPageTitle() {
        ClientFactoryImpl.INSTANCE.pageTitleService().resetTitle();
    }

    public static int renderComments(String parent, Element container) {
        ItemId parentId = ItemId.parse((String)parent);
        if (parentId == null) {
            throw new IllegalArgumentException("Parent Id is not an ItemId: " + parent);
        }
        CommentListWidget commentListWidget = new CommentListWidget(10, false, (ClientFactory)ClientFactoryImpl.INSTANCE);
        commentListWidget.fillGUI((HasComments)new /* Unavailable Anonymous Inner Class!! */);
        HTMLPanel wrapper = HTMLPanel.wrap((Element)container);
        wrapper.add((Widget)commentListWidget);
        WIDGETS.add(wrapper);
        return WIDGETS.indexOf(wrapper);
    }

    public static void removeCommentsWidget(int idx) {
        Panel widget = (Panel)WIDGETS.remove(idx);
        widget.clear();
        widget.removeFromParent();
    }

    public static void notifyEntitySubscriptionChange(@Nullable String entityTypeName) {
        EntityType entityType = entityTypeName != null ? EntityType.valueOf((String)entityTypeName) : null;
        ClientFactoryImpl.INSTANCE.eventManager().handleEvent((ClientEvent)new MyEntitySubscriptionsChangedEvent(entityType));
    }

    public static native void init();
}

