/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.shared;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.gwt.requestcollect.shared.CacheRequestCollect;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.BreadCrumbViewData;
import de.justsoftware.onx.container.shared.model.ComponentPositionConfig;
import de.justsoftware.onx.container.shared.model.DefaultEntityBaseData;
import de.justsoftware.onx.container.shared.model.EntityBadgeWithRole;
import de.justsoftware.onx.container.shared.model.EntityBaseData;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityExtendedData;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityInfoTabPrivacySettings;
import de.justsoftware.onx.container.shared.model.EntityStatistics;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.EntityTeaser;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.UpdateEntityResponse;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import de.justsoftware.onx.hierarchy.shared.model.EntityTreeItemData;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolation;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface EntityControllerAsync {
    public static final String GET_ENTITY_ANCHORS = "getEntityAnchors";
    public static final String PERSON_TEASER_WITH_FULL_NAMES = "personTeaserWithFullNames";
    public static final String GET_ALLOWED_ENTITY_SEARCH_ACTIONS = "getAllowedEntitySearchActions";
    public static final String GET_TEASERS = "getTeasers";

    public void getInfoById(EntityId var1, AsyncCallback<EntityInfo> var2);

    public void getInfoMapByIds(ImmutableSet<EntityId> var1, AsyncCallback<ImmutableMap<EntityId, EntityInfo>> var2);

    public void getDetailsById(EntityId var1, AsyncCallback<EntityDetails> var2);

    public void deleteEntity(EntityId var1, AsyncCallback<Void> var2);

    public void updateEntityBaseData(EntityBaseData var1, boolean var2, AsyncCallback<UpdateEntityResponse> var3);

    public void createEntity(EntityBaseData var1, EntityId var2, AsyncCallback<EntityId> var3);

    public void breadcrumb(GlobalId var1, EntityId var2, EntityId var3, AsyncCallback<BreadCrumbViewData> var4);

    public void deleteLogo(EntityId var1, AsyncCallback<Void> var2);

    public void deleteIcon(EntityId var1, AsyncCallback<Void> var2);

    public void deleteSlideshowImage(@Nonnull EntityId var1, @Nonnull AsyncCallback<Void> var2);

    public void setEntityComponentPositions(@Nonnull EntityId var1, @Nonnull ImmutableList<ComponentPositionConfig> var2, @Nonnull AsyncCallback<Void> var3);

    public void getBadgesByEntityTypeAndPerson(@Nonnull EntityType var1, @Nonnull PersonId var2, int var3, int var4, @Nonnull AsyncCallback<ListAndCount<EntityBadgeWithRole>> var5);

    public void checkParentEntityAssigmentAllowed(EntityId var1, EntityType var2, EntityId var3, AsyncCallback<Void> var4);

    public void getDirectChildEntityTree(@Nonnull EntityId var1, @Nonnull ImmutableSet<EntityType> var2, AsyncCallback<ImmutableList<EntityTreeItemData>> var3);

    public void getEntityTreeWithParentNodeByEntityId(@Nonnull EntityId var1, @Nonnull ImmutableSet<EntityType> var2, @Nonnull AsyncCallback<ImmutableList<EntityTreeItemData>> var3);

    public void getInfoForTypes(@Nonnull ImmutableSet<EntityType> var1, int var2, int var3, @Nonnull AsyncCallback<ListAndCount<EntityInfo>> var4);

    public void getParentSuggestionsForType(@Nullable EntityId var1, @Nonnull ImmutableSet<EntityType> var2, @Nonnull ImmutableSet<EntityId> var3, int var4, int var5, @Nonnull AsyncCallback<ListAndCount<EntityInfo>> var6);

    public void saveEntityExtendedData(@Nonnull EntityExtendedData var1, AsyncCallback<Void> var2);

    public void updateEntityDescription(EntityId var1, String var2, boolean var3, AsyncCallback<UpdateEntityResponse> var4);

    public void getPrivacySelectedAuthorityNames(EntityId var1, DBPrivacyType var2, AsyncCallback<ImmutableSet<String>> var3);

    public void defaultNewEntity(@Nullable EntityId var1, EntityType var2, @Nullable String var3, @Nullable Date var4, @Nonnull AsyncCallback<DefaultEntityBaseData> var5);

    public void validateEntityBaseData(EntityBaseData var1, AsyncCallback<ImmutableSet<JucoConstraintViolation>> var2);

    @Deprecated
    @CacheRequestCollect(name="personTeaserWithFullNames")
    public void getPersonTeaserModelsForDynamicAttributes(@Nonnull ImmutableSet<PersonId> var1, @Nonnull AsyncCallback<Map<PersonId, PersonTeaserModel>> var2);

    public void getAdminInheritanceParentsByEntityId(EntityId var1, boolean var2, AsyncCallback<ImmutableList<EntityInfo>> var3);

    public void getMemberInheritanceParentsByEntityId(EntityId var1, boolean var2, AsyncCallback<ImmutableList<EntityInfo>> var3);

    @CacheRequestCollect(name="getAllowedEntitySearchActions", timeToLiveMillis=-1L)
    public void getAllowedEntitySearchActions(@Nonnull ImmutableSet<EntityId> var1, @Nonnull AsyncCallback<HashMap<EntityId, ImmutableSet<Action>>> var2);

    @CacheRequestCollect(name="getAllowedEntitySearchActions", timeToLiveMillis=-1L)
    public void getAllowedEntitySearchActions(@Nonnull EntityId var1, @Nonnull AsyncCallback<ImmutableSet<Action>> var2);

    public void updateEntityTitle(@Nonnull EntityId var1, @Nonnull String var2, @Nonnull AsyncCallback<Void> var3);

    @CacheRequestCollect(name="getTeasers", timeToLiveMillis=60000L)
    public void getTeaser(@Nonnull ImmutableSet<EntityId> var1, @Nonnull AsyncCallback<HashMap<EntityId, EntityTeaser>> var2);

    @CacheRequestCollect(name="getTeasers", timeToLiveMillis=60000L)
    public void getTeaser(@Nonnull EntityId var1, @Nonnull AsyncCallback<EntityTeaser> var2);

    public void getStatisticsById(@Nonnull EntityId var1, @Nonnull AsyncCallback<EntityStatistics> var2);

    public void getEntityInfoTabPrivacySettings(EntityId var1, @Nonnull AsyncCallback<EntityInfoTabPrivacySettings> var2);

    @CacheRequestCollect(name="getEntityAnchors")
    public void getEntityAnchors(@Nonnull EntityId var1, @Nonnull AsyncCallback<ImmutableSet<String>> var2);

    @CacheRequestCollect(name="getEntityAnchors")
    public void getEntityAnchors(@Nonnull ImmutableSet<EntityId> var1, @Nonnull AsyncCallback<HashMap<EntityId, ImmutableSet<String>>> var2);

    public void getTabForHash(@Nonnull EntityId var1, @Nonnull String var2, @Nonnull AsyncCallback<EntityTab> var3);
}

