/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui.recommendastask;

import com.google.common.collect.ImmutableSet;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JCModalBox;
import de.justsoftware.onx.common.presentation.client.ui.JCSuggestBox;
import de.justsoftware.onx.common.presentation.client.ui.input.ValueInput;
import de.justsoftware.onx.common.presentation.client.ui.input.ValueInputWithInfo;
import de.justsoftware.onx.common.presentation.client.ui.input.ValueInputs;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.presentation.client.ui.recommendastask.EditablePager;
import de.justsoftware.onx.container.presentation.client.ui.recommendastask.RecommendEntityAsTaskView;
import de.justsoftware.onx.container.presentation.client.ui.recommendastask.RecommendEntityAsTaskViewImpl;
import de.justsoftware.onx.container.presentation.client.ui.recommendastask.SimpleEditablePager;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.presentation.client.EntitySolrSuggestOracle;
import de.justsoftware.onx.searchnew.presentation.client.PersonSolrSuggestOracle;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class RecommendEntityAsTaskViewImpl
implements RecommendEntityAsTaskView {
    private static final int SUGGESTION_LIMIT = 8;
    private final JCModalBox _modalBox;
    private final EntityConstants _i18n;
    private final BasicConstants _basicI18n;

    public RecommendEntityAsTaskViewImpl(EntityConstants i18n, BasicConstants basicI18n) {
        this._i18n = i18n;
        this._basicI18n = basicI18n;
        this._modalBox = new JCModalBox(this._i18n.recommend());
    }

    @Nonnull
    private Label errorLabel() {
        Label error = new Label();
        error.setVisible(false);
        error.addStyleName("error-message");
        return error;
    }

    public ValueInput<String> addInputField(String placeholder, String prefill) {
        ValueInputWithInfo valueInput = ValueInputs.createTextBox((String)placeholder, (String)prefill);
        this._modalBox.getContent().add((IsWidget)valueInput);
        return valueInput;
    }

    public ValueInput<String> addTextarea(String placeholder) {
        ValueInputWithInfo textarea = ValueInputs.createTextTextarea((String)placeholder);
        this._modalBox.getContent().add((IsWidget)textarea);
        return textarea;
    }

    public ValueInput<Integer> addDropdown(String ... options) {
        ValueInput dropdown = ValueInputs.createDropdown((String[])options);
        this._modalBox.getContent().add((IsWidget)dropdown);
        return dropdown;
    }

    public <T> EditablePager addPager(EditablePager.PagerDataProvider<T> dataProvider) {
        SimpleEditablePager pager = new SimpleEditablePager(dataProvider, this._basicI18n);
        this._modalBox.getContent().add((IsWidget)pager);
        return pager;
    }

    public void addFooter(String buttonText, RecommendEntityAsTaskView.SubmitHandler submitHandler) {
        JCButton btn = new JCButton(buttonText);
        btn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._modalBox.addCancelLink(this._i18n.cancel());
        this._modalBox.getFooter().add((Widget)btn);
    }

    public void show() {
        this._modalBox.show();
    }

    public void hide() {
        this._modalBox.hide();
    }

    public void showProgressIndicator() {
        this._modalBox.showProgressIndicator(true);
    }

    public void hideProgressIndicator() {
        this._modalBox.showProgressIndicator(false);
    }

    public void error(String message) {
        this._modalBox.error(message);
    }

    public void clearErrors() {
        this._modalBox.clearErrors();
    }

    public ValueInput<EntityId> addEntitySearchField(ImmutableSet<EntityType> entityTypes) {
        EntitySolrSuggestOracle oracle = new EntitySolrSuggestOracle(entityTypes, null);
        JCSuggestBox searchBox = new JCSuggestBox((SuggestOracle)oracle);
        searchBox.setSuggestPopupStyleName("jc-modal-box", true);
        searchBox.setLimit(8);
        searchBox.setPlaceholder(this._i18n.recommendationSearchForEntityLabel());
        searchBox.addStyleName("input");
        EntitySelectionHandler entitySelectionHandler = new EntitySelectionHandler(searchBox);
        searchBox.addSelectionHandler((SelectionHandler)entitySelectionHandler);
        this._modalBox.getContent().add((Widget)searchBox);
        return entitySelectionHandler;
    }

    public ValueInput<PersonId> addPersonSearchField() {
        PersonSolrSuggestOracle oracle = new PersonSolrSuggestOracle();
        JCSuggestBox searchBox = new JCSuggestBox((SuggestOracle)oracle);
        searchBox.setSuggestPopupStyleName("jc-modal-box", true);
        searchBox.setLimit(8);
        searchBox.setPlaceholder(this._i18n.recommendationSearchForUserLabel());
        searchBox.addStyleName("input");
        PersonSelectionHandler personSelectionHandler = new PersonSelectionHandler(searchBox);
        searchBox.addSelectionHandler((SelectionHandler)personSelectionHandler);
        this._modalBox.getContent().add((Widget)searchBox);
        return personSelectionHandler;
    }
}

