/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui.design;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.github.gwtbootstrap.client.ui.ButtonGroup;
import com.github.gwtbootstrap.client.ui.Fieldset;
import com.github.gwtbootstrap.client.ui.Legend;
import com.github.gwtbootstrap.client.ui.NavHeader;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.user.client.ui.JucoDropdownButton;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JCRadioButton;
import de.justsoftware.onx.common.presentation.client.ui.UIHtmlPanel;
import de.justsoftware.onx.common.presentation.client.ui.form.impl.Section;
import de.justsoftware.onx.container.presentation.client.presenter.EditEntityLinkCreator;
import de.justsoftware.onx.container.presentation.client.ui.design.ThemeAttributeControl;
import de.justsoftware.onx.container.presentation.client.ui.design.ThemeEditorView;
import de.justsoftware.onx.container.presentation.client.ui.design.ThemeEditorViewImpl;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EditEntityHistoryTokenTabName;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ThemeEditorViewImpl
implements ThemeEditorView {
    private static final ThemeEditorViewImplUIBinder UI_BINDER = (ThemeEditorViewImplUIBinder)GWT.create(ThemeEditorViewImplUIBinder.class);
    @UiField
    Section _mainNavigationContainer;
    @UiField
    FlowPanel _mainNavigationControls;
    @UiField
    FlowPanel _otherSettings;
    @UiField
    Section _otherSettingsContainer;
    @UiField
    Section _emailSettingsContainer;
    @UiField
    FlowPanel _emailSettings;
    @UiField
    Section _jucoNgLoginSettingsContainer;
    @UiField
    FlowPanel _jucoNgLoginSettings;
    @UiField
    FlowPanel _designControlContainer;
    @UiField
    HTMLPanel _defaultDesignSwitch;
    @UiField
    JCRadioButton _useDefaultDesign;
    @UiField
    JCRadioButton _useCustomDesign;
    @UiField
    JCButton _loadDefaultButton;
    @UiField
    ButtonGroup _submitButtons;
    @UiField(provided=true)
    final EntityConstants _entityConstants;
    private final HashMap<ThemeEditorView.ThemeEditorSection, Fieldset> _dynamicSections = Maps.newHashMap();
    private final ThemeEditorView.Presenter _presenter;
    private final UIHtmlPanel _container;
    private final JucoDropdownButton _continueButton = new JucoDropdownButton();

    public ThemeEditorViewImpl(ThemeEditorView.Presenter presenter, @Nullable EntityType entityType) {
        this._entityConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)entityType);
        this._container = (UIHtmlPanel)UI_BINDER.createAndBindUi((Object)this);
        this._presenter = presenter;
        this._continueButton.add((Widget)new NavHeader(this._entityConstants.finishAndContinueTo()));
        this._continueButton.setDropup(true);
    }

    @UiHandler(value={"_useDefaultDesign"})
    public void useDefaultDesign(ClickEvent event) {
        this._presenter.handleUseDefault(true);
    }

    @UiHandler(value={"_useCustomDesign"})
    public void useCustomDesign(ClickEvent event) {
        this._presenter.handleUseDefault(false);
    }

    public void addControls(ThemeEditorView.ThemeEditorSection sectionType, String sectionName, Iterable<ThemeAttributeControl> controls) {
        switch (1.$SwitchMap$de$justsoftware$onx$container$presentation$client$ui$design$ThemeEditorView$ThemeEditorSection[sectionType.ordinal()]) {
            case 1: {
                this.addControls((Panel)this._mainNavigationControls, controls);
                this._mainNavigationContainer.setVisible(true);
                break;
            }
            case 2: {
                this.addControls((Panel)this._otherSettings, controls);
                this._otherSettingsContainer.setVisible(true);
                break;
            }
            case 3: {
                this.addControls((Panel)this._emailSettings, controls);
                this._emailSettingsContainer.setVisible(true);
                break;
            }
            case 4: {
                this.addControls((Panel)this._jucoNgLoginSettings, controls);
                this._jucoNgLoginSettingsContainer.setVisible(true);
                break;
            }
            case 5: {
                this.addControls((Panel)this.getControlsForApps(ThemeEditorView.ThemeEditorSection.APPS), controls);
            }
        }
    }

    @Nonnull
    private Fieldset getControlsForApps(ThemeEditorView.ThemeEditorSection section) {
        Fieldset fieldset = (Fieldset)this._dynamicSections.get(section);
        if (fieldset == null) {
            fieldset = new Fieldset();
            fieldset.add((Widget)new Legend(I18nMediator.THEME_CONSTANTS.appSectionTitle()));
            this._designControlContainer.insert((Widget)fieldset, this._designControlContainer.getWidgetIndex((Widget)this._emailSettingsContainer));
            this._dynamicSections.put(section, fieldset);
        }
        return fieldset;
    }

    public void removeControl(ThemeEditorView.ThemeEditorSection section) {
        switch (1.$SwitchMap$de$justsoftware$onx$container$presentation$client$ui$design$ThemeEditorView$ThemeEditorSection[section.ordinal()]) {
            case 1: {
                this._mainNavigationContainer.removeFromParent();
                break;
            }
            case 2: {
                this._otherSettingsContainer.removeFromParent();
                break;
            }
            case 3: {
                this._emailSettingsContainer.removeFromParent();
                break;
            }
            case 4: {
                this._jucoNgLoginSettingsContainer.removeFromParent();
                break;
            }
        }
    }

    private void addControls(Panel parent, Iterable<ThemeAttributeControl> controls) {
        parent.setVisible(true);
        for (ThemeAttributeControl control : controls) {
            parent.add(control.asWidget());
        }
    }

    public void showDefaultThemeSwitch(boolean showSwitch) {
        this._defaultDesignSwitch.setVisible(showSwitch);
    }

    public void showThemeControls(boolean showControls) {
        this._designControlContainer.setVisible(showControls);
        this._useCustomDesign.setValue(Boolean.valueOf(showControls));
        this._useDefaultDesign.setValue(Boolean.valueOf(!showControls));
        this._loadDefaultButton.setVisible(showControls);
    }

    @UiHandler(value={"_cancelButton"})
    public void handleCancel(ClickEvent event) {
        this._presenter.handleCancel();
    }

    @UiHandler(value={"_finishButton"})
    public void handleFinish(ClickEvent event) {
        this._presenter.handleFinish();
    }

    @UiHandler(value={"_loadDefaultButton"})
    public void handleLoadDefault(ClickEvent even) {
        this._presenter.handleLoadDefault();
    }

    public Widget asWidget() {
        return this._container;
    }

    public void setLoadDefaultDesignButtonText(String loadDefaultDesignButtonText) {
        this._loadDefaultButton.setText(loadDefaultDesignButtonText);
    }

    public void addSaveAndContinueButton(ImmutableMap<EditEntityHistoryTokenTabName, ClickHandler> visibleTabs) {
        this._submitButtons.add((Widget)this._continueButton);
        visibleTabs.forEach((tab, clickHandler) -> this._continueButton.add((Widget)EditEntityLinkCreator.createLink((EditEntityHistoryTokenTabName)tab, (ClickHandler)clickHandler, (EntityConstants)this._entityConstants)));
    }
}

