/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.RangeChangeEvent;
import de.justsoftware.onx.common.presentation.client.ui.JCPopupPanel;
import de.justsoftware.onx.common.presentation.client.ui.ShowMorePagerPanel;
import de.justsoftware.onx.common.presentation.client.ui.WaitSpinner;
import de.justsoftware.onx.components.presentation.client.ui.ShowPopupUtils;
import de.justsoftware.onx.container.presentation.client.ui.ShowMorePopupView;
import javax.annotation.Nonnull;

public class ShowMoreProfilesPopupViewImpl<T>
implements ShowMorePopupView<T> {
    private static final String HEIGHT = "200px";
    private final ShowMorePagerPanel _scrollPager;
    private final Panel _loadingIndicator = new FlowPanel();
    private final CellList<T> _list;
    private ShowMorePopupView.Presenter _presenter;
    private final int _itemsPerPage;
    private JCPopupPanel _popup = null;

    public ShowMoreProfilesPopupViewImpl(@Nonnull Cell<T> cell, int itemsPerPage) {
        this._itemsPerPage = itemsPerPage;
        this._loadingIndicator.setWidth("100%");
        this._loadingIndicator.getElement().getStyle().setProperty("textAlign", "center");
        this._loadingIndicator.add((Widget)new WaitSpinner());
        this._list = new CellList(cell);
        this._list.addRangeChangeHandler((RangeChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this._list.setPageSize(this._itemsPerPage);
        this._list.setLoadingIndicator((Widget)this._loadingIndicator);
        this._scrollPager = new ShowMorePagerPanel();
        this._scrollPager.setDisplay((HasRows)this._list);
        this._scrollPager.setHeight(HEIGHT);
    }

    public void show(Widget popupPos) {
        if (this._popup != null) {
            this.hide();
        }
        this._popup = new JCPopupPanel(true, true);
        this._popup.addStyleName("show-more-profiles-popup");
        this._popup.setAnimationType(PopupPanel.AnimationType.ONE_WAY_CORNER);
        FlowPanel content = new FlowPanel();
        content.add((Widget)this._scrollPager);
        ShowPopupUtils.showRelativeTo((PopupPanel)this._popup, (Widget)content, (UIObject)popupPos);
        this._scrollPager.reset();
        this._list.setVisibleRangeAndClearData(new Range(0, this._itemsPerPage), true);
    }

    public HasData<T> getList() {
        return this._list;
    }

    public void setPresenter(ShowMorePopupView.Presenter presenter) {
        this._presenter = presenter;
    }

    public void setNoDataText(String noDataText) {
        Label noDataLabel = new Label(noDataText);
        noDataLabel.addStyleName("showMorePopupNoDataLabel");
        this._list.setEmptyListWidget((Widget)noDataLabel);
    }

    public void hide() {
        if (this.isShowing()) {
            this._popup.hide();
        }
        this._popup = null;
    }

    public boolean isShowing() {
        return this._popup != null && this._popup.isShowing();
    }

    public void setCaption(String caption) {
    }
}

