/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.google.common.collect.ImmutableSet;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.teasers.EntitySelectedParentTeaserWidget;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.Actions;
import de.justsoftware.onx.container.presentation.client.EntityParent;
import de.justsoftware.onx.container.presentation.client.ui.EntityParentSelectWidget;
import de.justsoftware.onx.container.presentation.client.ui.EntitySelectedParentsWidget;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class EntitySelectedParentsWidget
extends Composite {
    private static final EntitySelectedParentsWidgetUIBinder UI_BINDER = (EntitySelectedParentsWidgetUIBinder)GWT.create(EntitySelectedParentsWidgetUIBinder.class);
    @UiField
    FlowPanel _entityRows;
    @UiField(provided=true)
    EntityConstants _entityConstants;
    private final EntityParentSelectWidget _entityParentSelectWidget;
    private final Map<EntityId, InlineFeedbackWidget> _selectedParents = new HashMap();

    public EntitySelectedParentsWidget(@Nonnull EntityParentSelectWidget entityParentSelectWidget) {
        this._entityParentSelectWidget = entityParentSelectWidget;
        this._entityConstants = entityParentSelectWidget._entityConstants;
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
    }

    public void reloadView(@Nonnull Iterable<EntityParent> selectedParents, @Nonnull ImmutableSet<Action> allowedActions) {
        this._entityRows.clear();
        this._selectedParents.clear();
        for (EntityParent entityParent : selectedParents) {
            boolean mayEditParent = allowedActions.contains((Object)Actions.entityModifyParent((EntityType)((EntityType)entityParent.getParentEntity().getType())));
            EntityInfo entity = entityParent.getParentEntity();
            EntitySelectedParentTeaserWidget teaser = new EntitySelectedParentTeaserWidget(entity, null, mayEditParent ? this._entityParentSelectWidget.createDeleteSelectedParentClickHandler(entity) : null);
            InlineFeedbackWidget inlineFeedbackWidget = new InlineFeedbackWidget();
            this._entityRows.add((Widget)teaser);
            this._entityRows.add((Widget)inlineFeedbackWidget);
            this._selectedParents.put((EntityId)entity.getId(), inlineFeedbackWidget);
        }
        this.setVisible(this._selectedParents.size() != 0);
    }

    public void showErrorMessageForEntities(@Nonnull Set<EntityId> entityIds, @Nonnull String message) {
        for (EntityId id : entityIds) {
            InlineFeedbackWidget inlineFeedbackWidget = (InlineFeedbackWidget)this._selectedParents.get(id);
            if (inlineFeedbackWidget == null) continue;
            inlineFeedbackWidget.setMessage(message);
            inlineFeedbackWidget.show(InlineFeedbackWidget.InlineType.ERROR);
        }
    }

    public void clearErrors() {
        for (InlineFeedbackWidget inlineFeedbackWidget : this._selectedParents.values()) {
            inlineFeedbackWidget.hide();
        }
    }
}

