/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.client.ErrorHandlingAsyncCallback;
import com.freiheit.toro.common.presentation.ui.AbstractImageUploadHtmlWidget;
import com.freiheit.toro.common.presentation.ui.ImageUploadHtmlWidget;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.github.gwtbootstrap.client.ui.ButtonGroup;
import com.github.gwtbootstrap.client.ui.NavHeader;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiFactory;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.jsinterop.Callback;
import de.justsoftware.gwt.user.client.ui.JucoDropdownButton;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.ClientEvent;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.upload.OnUploadHandler;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.presentation.client.EntityChangedEvent;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.presentation.client.presenter.EditEntityLinkCreator;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditImageWidget;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditView;
import de.justsoftware.onx.container.presentation.client.ui.EntityIconCreator;
import de.justsoftware.onx.container.presentation.client.ui.EntityLogoCreator;
import de.justsoftware.onx.container.presentation.client.ui.EntitySlideshowCreator;
import de.justsoftware.onx.container.presentation.shared.model.entityedit.ImageEntityEditModel;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EditEntityHistoryTokenTabName;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.teasers.StaticTeaser;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityEditImageWidget
extends Composite
implements EntityEditView {
    private static final EntityEditImageWidgetUIBinder UI_BINDER = (EntityEditImageWidgetUIBinder)GWT.create(EntityEditImageWidgetUIBinder.class);
    @UiField
    Panel _iconPanel;
    @UiField
    Panel _logoPanel;
    @UiField
    Panel _slideshowPanel;
    @UiField
    JCButton _finishButton;
    @UiField
    ButtonGroup _submitButtons;
    private final ImageUploadHtmlWidget _iconUpload;
    private final ImageUploadHtmlWidget _logoUpload;
    private final ImageUploadHtmlWidget _slideshowUpload;
    private final EntityId _entityId;
    private final EntityType _entityType;
    private final EntityConstants _entityConstants;
    private final ClientFactory _clientFactory;
    private final JucoDropdownButton _continueButton = new JucoDropdownButton();
    private final Callback<EditEntityHistoryTokenTabName> _submitCallback;
    private final ErrorHandlingAsyncCallback<Void> _updateCallback = new /* Unavailable Anonymous Inner Class!! */;

    public EntityEditImageWidget(ClientFactory clientFactory, ImageEntityEditModel entityEditModel, Callback<EditEntityHistoryTokenTabName> submitCallback) {
        this._entityId = (EntityId)entityEditModel.getEntityInfo().getId();
        this._entityType = entityEditModel.getEntityType();
        this._clientFactory = clientFactory;
        this._submitCallback = submitCallback;
        ClientEntityConfig config = HostPropertiesMediator.getClientEntityConfig((EntityType)entityEditModel.getEntityType());
        this._entityConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)entityEditModel.getEntityType());
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        if (config.isIconActivated()) {
            this._iconUpload = this.createImageUploadWidget("icon", this._entityConstants.currentIcon(), this._entityConstants.uploadIcon(), this._entityConstants.deleteIcon(), AbstractImageUploadHtmlWidget.getYouCanUploadPictureType());
            this._iconUpload.addRemovePictureClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this._iconPanel.add((Widget)this._iconUpload);
        } else {
            this._iconPanel.setVisible(false);
            this._iconUpload = null;
        }
        if (config.isLogoActivated()) {
            this._logoUpload = this.createImageUploadWidget("logo", this._entityConstants.currentLogo(), this._entityConstants.uploadLogo(), this._entityConstants.deleteLogo(), AbstractImageUploadHtmlWidget.getYouCanUploadPictureType());
            this._logoUpload.addRemovePictureClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this._logoPanel.add((Widget)this._logoUpload);
        } else {
            this._logoPanel.setVisible(false);
            this._logoUpload = null;
        }
        if (ImmutableSet.of((Object)config.getTeaserLeft(), (Object)config.getTeaserCenter(), (Object)config.getTeaserRight()).contains((Object)StaticTeaser.SLIDESHOW_TEASER)) {
            this._slideshowUpload = this.createImageUploadWidget("slideshow", this._entityConstants.currentSlideshowImage(), this._entityConstants.uploadSlideshowImage(), this._entityConstants.deleteSlideshowImage(), this._entityConstants.slideshowImageUploadInfoText());
            this._slideshowUpload.addRemovePictureClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this._slideshowPanel.add((Widget)this._slideshowUpload);
        } else {
            this._slideshowPanel.setVisible(false);
            this._slideshowUpload = null;
        }
        this.configureContinueButton(entityEditModel);
        this.updateEntity(entityEditModel.getEntityInfo());
    }

    private void configureContinueButton(ImageEntityEditModel editModel) {
        this._continueButton.add((Widget)new NavHeader(this._entityConstants.finishAndContinueTo()));
        this._continueButton.setDropup(true);
        ImmutableMap visibleTabs = FluentIterable.from((Iterable)editModel.getVisibleTabs()).filter(tab -> EditEntityHistoryTokenTabName.IMAGE != tab).toMap(tab -> e -> this._submitCallback.call(tab));
        if (!visibleTabs.isEmpty()) {
            this.addSaveAndContinueButton(visibleTabs);
        }
    }

    public void addSaveAndContinueButton(ImmutableMap<EditEntityHistoryTokenTabName, ClickHandler> visibleTabs) {
        this._submitButtons.add((Widget)this._continueButton);
        visibleTabs.forEach((tab, clickHandler) -> this._continueButton.add((Widget)EditEntityLinkCreator.createLink((EditEntityHistoryTokenTabName)tab, (ClickHandler)clickHandler, (EntityConstants)this._entityConstants)));
    }

    @Nonnull
    private ImageUploadHtmlWidget createImageUploadWidget(String type, String current, String upload, String delete, String uploadInfoText) {
        Supplier parameters = Suppliers.ofInstance((Object)ImmutableMap.of((Object)"type", (Object)type, (Object)"entityId", (Object)Long.toString(this._entityId.getId())));
        ImageUploadHtmlWidget w = new ImageUploadHtmlWidget(null, UrlUtil.generateUploadUrl((String)"/entity"), parameters, delete, null, 1, true);
        w.getHeaderPanel().add((Widget)new Label(uploadInfoText));
        w.setOriginalImageWidth(true);
        w.setCaption(upload, upload);
        w.setImageTitle(current);
        w.setOnUploadHandler((OnUploadHandler)new /* Unavailable Anonymous Inner Class!! */);
        return w;
    }

    private void updateOtherTabs() {
        this._clientFactory.eventManager().handleEvent((ClientEvent)new EntityChangedEvent(this._entityId, this._entityType));
        EntityMediator.getInstance().getInfoById(this._entityId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateEntity(EntityInfo result) {
        if (result != null) {
            if (this._iconUpload != null) {
                if (StringUtil.isBlank((String)result.getIcon())) {
                    this._iconUpload.setImageWidget(EntityIconCreator.DEFAULT.createDefaultIcon(result.getApp(), (EntityType)result.getType()));
                } else {
                    this._iconUpload.setImageUrl(ImageUrlUtil.getFullEntityImageUrl((EntityType)((EntityType)result.getType()), (ImageSize)ImageSize.ICON_SMALL, (String)result.getIcon()));
                }
                this._iconUpload.showRemoveClickButton(!StringUtil.isBlank((String)result.getIcon()));
            }
            if (this._logoUpload != null) {
                if (StringUtil.isBlank((String)result.getLogo())) {
                    Widget logo = new EntityLogoCreator(ImageSize.LARGE).createDefaultLogo(result.getApp(), (EntityType)result.getType(), true);
                    this._logoUpload.setImageWidget(logo);
                } else {
                    this._logoUpload.setImageUrl(ImageUrlUtil.getFullEntityImageUrl((EntityType)((EntityType)result.getType()), (ImageSize)ImageSize.LARGE, (String)result.getLogo()));
                }
                this._logoUpload.showRemoveClickButton(!StringUtil.isBlank((String)result.getLogo()));
            }
            if (this._slideshowUpload != null) {
                if (StringUtil.isBlank((String)result.getSlideshowImage())) {
                    Widget slideshow = new EntitySlideshowCreator(ImageSize.LARGE).createDefaultSlideshow((EntityType)result.getType(), true);
                    this._slideshowUpload.setImageWidget(slideshow);
                } else {
                    this._slideshowUpload.setImageUrl(ImageUrlUtil.getFullEntitySlideshowImageUrl((EntityType)((EntityType)result.getType()), (ImageSize)ImageSize.LARGE, (String)result.getSlideshowImage()));
                }
                this._slideshowUpload.showRemoveClickButton(!StringUtil.isBlank((String)result.getSlideshowImage()));
            }
        }
    }

    @Nonnull
    @UiFactory
    public EntityConstants getEntityConstants() {
        return this._entityConstants;
    }

    @UiHandler(value={"_finishButton"})
    void handleCreateAndFinishButton(ClickEvent event) {
        this._submitCallback.call(null);
    }
}

