/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.ui.ConfirmPopup;
import com.github.gwtbootstrap.client.ui.NavList;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.model.Promise;
import de.justsoftware.onx.common.presentation.client.ui.DoLeaveEntityOrEventClickHandler;
import de.justsoftware.onx.common.presentation.client.ui.JCEntityBadgeActionPopupPanel;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.common.presentation.client.ui.JCNavWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCPopupPanel;
import de.justsoftware.onx.common.presentation.client.ui.WaitSpinner;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.action.StaticItemAction;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.presentation.client.EntityMemberClientFactory;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.like.shared.model.SubscriptionStatus;
import de.justsoftware.onx.searchnew.shared.model.EntitySearchResultBadgeModel;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JCEntityBadgeActionPopupPanel
extends JCPopupPanel {
    private static final String OPEN_STYLE = "open";
    private final ClientFactory _clientFactory;
    private final EntityMemberClientFactory _entityMemberClientFactory;
    private final EntitySearchResultBadgeModel _badge;
    private final NavList _content = new NavList();
    private final SimplePanel _actionContainer = new SimplePanel();
    private final EntityConstants _entityConstants;
    private JCIconOnlyAnchor _actionAnchor;
    private Set<Action> _may = ImmutableSet.of();

    public JCEntityBadgeActionPopupPanel(@Nonnull EntitySearchResultBadgeModel badge, @Nonnull ClientFactory clientFactory) {
        super(true);
        this._badge = badge;
        this._entityConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)((EntityType)this._badge.getType()));
        this._clientFactory = clientFactory;
        this._entityMemberClientFactory = clientFactory.entityMemberClientFactory();
        this.add((Widget)this._content);
        this.updateAllowedActions();
        this.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Nonnull
    public SimplePanel getActionPanel() {
        return this._actionContainer;
    }

    @Nonnull
    private JCIconOnlyAnchor getActionAnchor() {
        if (this._actionAnchor == null) {
            this._actionAnchor = new JCIconOnlyAnchor();
            this._actionAnchor.setIcon(IconType.ELLIPSIS_VERTICAL);
            this._actionAnchor.setIconSize(IconSize.LARGE);
            this._actionAnchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.addAutoHidePartner((Element)this._actionAnchor.getElement());
        }
        return this._actionAnchor;
    }

    private void updateLinks() {
        this._content.clear();
        switch (19.$SwitchMap$de$justsoftware$onx$container$shared$model$EntityMemberWorkflow[this._badge.getMemberWorkflow().ordinal()]) {
            case 1: {
                this.addMembershipActions();
                break;
            }
            case 2: {
                this.addEventActions();
            }
        }
        this.addAdministrativeActions();
        this.addSubscriptionActions();
        this.addEntityActions();
    }

    private void updateAllowedActions() {
        this._actionContainer.setWidget((Widget)new WaitSpinner());
        EntityMediator.getInstance().getAllowedEntitySearchActions((EntityId)this._badge.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateAllowedActions(@Nullable ImmutableSet<Action> allowedActions) {
        this._may = allowedActions;
        if (CollectionUtil.isEmpty((Iterable)this._may)) {
            this._actionContainer.setWidget(null);
            return;
        }
        this._actionContainer.setWidget((Widget)this.getActionAnchor());
        this.updateLinks();
    }

    private void addSubscriptionActions() {
        4 callback = new /* Unavailable Anonymous Inner Class!! */;
        boolean subscribeVisible = this._may.contains(StaticItemAction.LIKE_SUBSCRIBE);
        boolean unsubscribeVisible = this._may.contains(StaticItemAction.UNLIKE_UNSUBSCRIBE);
        if (subscribeVisible) {
            this.addSubscribeLink((AsyncCallback)callback);
        }
        if (unsubscribeVisible) {
            this.addUnsubscribeLink((AsyncCallback)callback);
        }
    }

    private void addSubscribeLink(@Nonnull AsyncCallback<SubscriptionStatus> callback) {
        JCNavWidget subscribeLink = new JCNavWidget();
        subscribeLink.setIcon(IconType.THUMBS_UP);
        subscribeLink.setTextAndTitle(I18nMediator.LIKE.subscribe());
        subscribeLink.setVisible(true);
        subscribeLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._content.add((Widget)subscribeLink);
    }

    private void addUnsubscribeLink(@Nonnull AsyncCallback<SubscriptionStatus> callback) {
        JCNavWidget unsubscribeLink = new JCNavWidget();
        unsubscribeLink.setIcon(IconType.REMOVE_SIGN);
        unsubscribeLink.setTextAndTitle(I18nMediator.LIKE.unsubscribe());
        unsubscribeLink.setVisible(true);
        unsubscribeLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._content.add((Widget)unsubscribeLink);
    }

    private void addMembershipActions() {
        if (this._may.contains(StaticEntityAction.ENTITY_JOIN)) {
            this._content.add((Widget)this.createJoinEntityLink());
        }
        if (this._may.contains(StaticEntityAction.ENTITY_JOIN_REQUEST)) {
            this._content.add((Widget)this.createJoinRequestLink());
        }
        if (this._may.contains(StaticEntityAction.ENTITY_ACCEPT_INVITE)) {
            this._content.add((Widget)this.createAcceptInvitationLink());
        } else if (this._may.contains(StaticEntityAction.ENTITY_LEAVE)) {
            this._content.add((Widget)this.createLeaveEntityLink());
        }
        if (this._may.contains(StaticEntityAction.ENTITY_REMOVE_JOIN_REQUEST)) {
            this._content.add((Widget)this.createRemoveJoinRequestLink());
        }
        if (this._may.contains(StaticEntityAction.ENTITY_INVITE)) {
            this._content.add((Widget)this.createInviteLink());
        }
    }

    private void addEventActions() {
        if (this._may.contains(StaticEntityAction.EVENT_ATTEND)) {
            this._content.add((Widget)this.createAttendEventLink());
        }
        if (this._may.contains(StaticEntityAction.EVENT_DONT_ATTEND)) {
            this._content.add((Widget)this.createDontAttendEventLink());
        }
        if (this._may.contains(StaticEntityAction.EVENT_MAYBE_ATTEND)) {
            this._content.add((Widget)this.createMaybeAttendEventLink());
        }
        if (this._may.contains(StaticEntityAction.ENTITY_LEAVE)) {
            if (this._may.contains(StaticEntityAction.ENTITY_ACCEPT_INVITE)) {
                this._content.add((Widget)this.createRejectInvitationLink());
            } else {
                this._content.add((Widget)this.createLeaveEntityLink());
            }
        }
        if (this._may.contains(StaticEntityAction.EVENT_INVITE)) {
            this._content.add((Widget)this.createInviteLink());
        }
    }

    private void addAdministrativeActions() {
        if (this._may.contains(StaticEntityAction.ENTITY_MAKE_ADMIN)) {
            this._content.add((Widget)this.createMakeAdminLink());
        }
        if (this._may.contains(StaticEntityAction.ENTITY_MAKE_COADMIN)) {
            this._content.add((Widget)this.createMakeCoAdminLink());
        }
    }

    private void addEntityActions() {
        if (this._may.contains(StaticEntityAction.ENTITY_RECOMMEND)) {
            this._content.add((Widget)this.createRecommendLink());
        }
        EntityVersionClientModel entityVersion = this._badge.getVersion();
        if (this._may.contains(StaticEntityAction.ENTITY_ARCHIVE) && entityVersion != null) {
            this._content.add((Widget)this.createArchiveLink(entityVersion));
        }
    }

    @Nonnull
    private JCNavWidget createArchiveLink(@Nonnull EntityVersionClientModel entityVersion) {
        JCNavWidget archiveLink = new JCNavWidget();
        archiveLink.setIcon(IconType.HDD);
        archiveLink.setTextAndTitle(I18nMediator.ENTITY_VERSION_CONSTANTS.archive());
        archiveLink.setVisible(true);
        archiveLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return archiveLink;
    }

    @Nonnull
    private JCNavWidget createMakeCoAdminLink() {
        JCNavWidget makeCoAdminLink = new JCNavWidget();
        makeCoAdminLink.setIcon(IconType.ASTERISK);
        makeCoAdminLink.setTextAndTitle(this._entityConstants.makeCoAdmin());
        makeCoAdminLink.setVisible(true);
        makeCoAdminLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return makeCoAdminLink;
    }

    @Nonnull
    private JCNavWidget createMakeAdminLink() {
        JCNavWidget makeAdminLink = new JCNavWidget();
        makeAdminLink.setIcon(IconType.TROPHY);
        makeAdminLink.setTextAndTitle(this._entityConstants.makeAdmin());
        makeAdminLink.setVisible(true);
        makeAdminLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return makeAdminLink;
    }

    @Nonnull
    private JCNavWidget createInviteLink() {
        JCNavWidget inviteLink = new JCNavWidget();
        inviteLink.setIcon(IconType.PLUS);
        inviteLink.setTextAndTitle(this._entityConstants.inviteToEntity());
        inviteLink.setVisible(true);
        inviteLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return inviteLink;
    }

    @Nonnull
    private JCNavWidget createRecommendLink() {
        JCNavWidget recommendLink = new JCNavWidget();
        recommendLink.setIcon(IconType.HAND_RIGHT);
        recommendLink.setTextAndTitle(this._entityConstants.recommend());
        recommendLink.setVisible(true);
        recommendLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return recommendLink;
    }

    @Nonnull
    private JCNavWidget createJoinEntityLink() {
        JCNavWidget joinEntityLink = new JCNavWidget();
        joinEntityLink.setIcon(IconType.SIGNIN);
        joinEntityLink.setTextAndTitle(this._entityConstants.joinEntity());
        joinEntityLink.setVisible(true);
        joinEntityLink.addClickHandler(this.getJoinEntityClickHandler(false));
        return joinEntityLink;
    }

    @Nonnull
    private JCNavWidget createJoinRequestLink() {
        JCNavWidget joinRequestLink = new JCNavWidget();
        joinRequestLink.setIcon(IconType.SIGNIN);
        joinRequestLink.setTextAndTitle(this._entityConstants.sendJoinRequest());
        joinRequestLink.setVisible(true);
        joinRequestLink.addClickHandler(this.getJoinEntityClickHandler(true));
        return joinRequestLink;
    }

    @Nonnull
    private ClickHandler getJoinEntityClickHandler(boolean joinRequest) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nonnull
    private JCNavWidget createLeaveEntityLink() {
        JCNavWidget leaveEntityLink = new JCNavWidget();
        leaveEntityLink.setIcon(IconType.SIGNOUT);
        leaveEntityLink.setTextAndTitle(this._entityConstants.leaveEntity());
        leaveEntityLink.setVisible(true);
        leaveEntityLink.addClickHandler(event -> {
            this.hide();
            13 leaveEntityCallback = new /* Unavailable Anonymous Inner Class!! */;
            ConfirmPopup.makeConfirmPopup((String)this._entityConstants.realyWantToLeaveEntity(), (ClickHandler)new DoLeaveEntityOrEventClickHandler((EntityInfo)this._badge, (AsyncCallback)leaveEntityCallback), null, (ConfirmPopup.ButtonType)ConfirmPopup.ButtonType.YES_NO).show();
        });
        return leaveEntityLink;
    }

    @Nonnull
    private JCNavWidget createRemoveJoinRequestLink() {
        JCNavWidget removeJoinRequestLink = new JCNavWidget();
        removeJoinRequestLink.setIcon(IconType.SIGNOUT);
        removeJoinRequestLink.setTextAndTitle(this._entityConstants.removeJoinEntityRequest());
        removeJoinRequestLink.setVisible(true);
        removeJoinRequestLink.addClickHandler(e -> {
            this.hide();
            this._entityMemberClientFactory.clientService().deleteJoinRequest((EntityId)this._badge.getId(), (EntityType)this._badge.getType()).then(result -> {
                this.updateAllowedActions();
                return result;
            }, Promise.DEFAULT_ERROR_HANDLER);
        });
        return removeJoinRequestLink;
    }

    @Nonnull
    private JCNavWidget createAcceptInvitationLink() {
        JCNavWidget acceptInvitationLink = new JCNavWidget();
        acceptInvitationLink.setTextAndTitle(this._entityConstants.acceptInvitationOption());
        acceptInvitationLink.setIcon(IconType.SIGNIN);
        acceptInvitationLink.setVisible(true);
        acceptInvitationLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return acceptInvitationLink;
    }

    @Nonnull
    private JCNavWidget createRejectInvitationLink() {
        JCNavWidget actionLink = new JCNavWidget();
        actionLink.setIcon(IconType.SIGNOUT);
        actionLink.setTextAndTitle(this._entityConstants.rejectInvitationToEvent());
        actionLink.setVisible(true);
        actionLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return actionLink;
    }

    @Nonnull
    private JCNavWidget createAttendEventLink() {
        JCNavWidget actionLink = new JCNavWidget();
        actionLink.setIcon(IconType.CHECK);
        actionLink.setTextAndTitle(this._entityConstants.attendEvent());
        actionLink.setVisible(true);
        actionLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return actionLink;
    }

    @Nonnull
    private JCNavWidget createDontAttendEventLink() {
        JCNavWidget actionLink = new JCNavWidget();
        actionLink.setIcon(IconType.REMOVE);
        actionLink.setTextAndTitle(this._entityConstants.dontAttendEvent());
        actionLink.setVisible(true);
        actionLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return actionLink;
    }

    @Nonnull
    private JCNavWidget createMaybeAttendEventLink() {
        JCNavWidget actionLink = new JCNavWidget();
        actionLink.setIcon(IconType.QUESTION_SIGN);
        actionLink.setTextAndTitle(this._entityConstants.maybeAttendEvent());
        actionLink.setVisible(true);
        actionLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        return actionLink;
    }

    public boolean hasActions() {
        return this._content.getWidgetCount() > 0;
    }
}

