/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.presenter;

import com.freiheit.toro.account.presentation.ui.LoginManagerImpl;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.presentation.client.model.AuthorSelectionModelImpl;
import de.justsoftware.onx.common.presentation.client.ui.EntityReleaseAuthorSelectionView;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.presentation.client.EntityVersionClientFactory;
import de.justsoftware.onx.container.shared.i18n.EntityVersionConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.person.presentation.client.PersonMediator;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import javax.annotation.Nonnull;

public class EntityReleaseAuthorSelectionPresenterImpl
implements EntityReleaseAuthorSelectionView.EntityReleaseAuthorSelectionPresenter {
    private final EntityReleaseAuthorSelectionView _view;
    private EntityReleaseAuthorSelectionView.AuthorSelectionModel _selected;
    private EntityReleaseAuthorSelectionView.AuthorSelectionModel _default;
    private final PersonId _authorId;
    private final EntityVersionConstants _versionMessages = I18nMediator.LOCALIZED_MESSAGES.entityVersionConstants();

    public EntityReleaseAuthorSelectionPresenterImpl(@Nonnull EntityVersionClientFactory factory, @Nonnull ClientEntityConfig entityConfig, @Nonnull EntityId entityId, @Nonnull PersonId currentAuthorId) {
        this._view = factory.entityReleaseAuthorSelectionView(entityConfig, entityId, (EntityReleaseAuthorSelectionView.EntityReleaseAuthorSelectionPresenter)this);
        this._authorId = currentAuthorId;
        this.resetToDefault();
    }

    public void setSelected(EntityReleaseAuthorSelectionView.AuthorSelectionModel selected) {
        if (this._selected == null || !this._selected.equals(selected)) {
            this._selected = selected;
            this._view.setSelected(this._selected);
        }
    }

    public EntityReleaseAuthorSelectionView getView() {
        return this._view;
    }

    public PersonId getSelected() {
        return this._selected != null ? this._selected.getId() : (this._default != null ? this._default.getId() : this._authorId);
    }

    public void resetToDefault() {
        if (this._default == null) {
            PersonTeaserModel currentUser = LoginManagerImpl.getInstance().getUser();
            if (currentUser != null) {
                this._default = new AuthorSelectionModelImpl((PersonId)currentUser.getId(), currentUser.getFullName());
                this.setSelected(this._default);
            } else {
                this._default = new AuthorSelectionModelImpl(this._authorId, this._versionMessages.currentUser());
                this.setSelected(this._default);
                PersonMediator.getInstance().getPersonTeaserModelById(this._authorId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        } else {
            this.setSelected(this._default);
        }
    }
}

