/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.calendar.presentation.client.ui;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.calendar.presentation.client.ui.Calendar;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.EntityBadge;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class CalendarView
extends Composite {
    public static final DateTimeFormat DATE_KEY_FORMATTER = DateTimeFormat.getFormat((String)"dd.MM.yyyy");
    private static final Predicate<EntityBadge> WHOLE_DAY_ENTITIES_PREDICATE = new /* Unavailable Anonymous Inner Class!! */;
    private static final Predicate<EntityBadge> TIMED_ENTITIES_PREDICATE = new /* Unavailable Anonymous Inner Class!! */;
    private static final Ordering<EntityBadge> SORT_BY_START_AND_END_DATE = Ordering.natural().onResultOf(EntityBadge.GET_START_AT).compound((Comparator)Ordering.natural().onResultOf(EntityBadge.GET_END_AT).reverse());
    protected int _viewWidth;
    protected int _viewHeight;
    protected AbsolutePanel _absoluteContentPanel;
    protected final boolean _mayCreate;
    protected final EntityType _entityType;

    public CalendarView(int viewWidht, int viewHeight, boolean mayCreate, EntityType type) {
        this._viewHeight = viewHeight;
        this._viewWidth = viewWidht;
        this._absoluteContentPanel = new AbsolutePanel();
        this._absoluteContentPanel.setWidth(this._viewWidth + "px");
        this._absoluteContentPanel.setHeight(this._viewHeight + "px");
        this.initWidget((Widget)this._absoluteContentPanel);
        this._entityType = type;
        this._mayCreate = mayCreate;
    }

    protected void clear() {
        this._absoluteContentPanel.clear();
    }

    protected void addToContent(Widget w, int left, int top) {
        this._absoluteContentPanel.add(w, left, top);
    }

    public int getViewHeight() {
        return this._viewHeight;
    }

    public int getViewWidth() {
        return this._viewWidth;
    }

    public void updateView(Calendar calendar) {
        this.initView(calendar);
        calendar.setDataLoadingInProgress(true);
        Date start = this.getCurrentStartDate(calendar);
        Date end = this.getCurrentEndDate(calendar);
        calendar.getDataProvider().getAppointments(start, end, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static boolean isWholeDay(EntityBadge input) {
        DateWithoutTimezone end;
        DateWithoutTimezone start = input.getStartAt();
        return Dates.isWholeDay((Date)start, (Date)(end = input.getEndAt())) || !Dates.areOnTheSameDay((Date)start, (Date)end);
    }

    private void handleAfterRetrieveAppointments(Date startDate, Iterable<? extends EntityBadge> result, Calendar calendar) {
        ImmutableList entityBadges;
        ImmutableSet appointments = CalendarView.convertAppointmentToMap((Date)startDate, result).asMap().entrySet();
        for (Map.Entry apps : appointments) {
            entityBadges = SORT_BY_START_AND_END_DATE.immutableSortedCopy(Iterables.filter((Iterable)((Iterable)apps.getValue()), (Predicate)WHOLE_DAY_ENTITIES_PREDICATE));
            if (entityBadges.isEmpty()) continue;
            this.addWholeDaysAppointmentsToView(DATE_KEY_FORMATTER.parse((String)apps.getKey()), (Iterable)entityBadges, calendar);
        }
        for (Map.Entry apps : appointments) {
            entityBadges = SORT_BY_START_AND_END_DATE.immutableSortedCopy(Iterables.filter((Iterable)((Iterable)apps.getValue()), (Predicate)TIMED_ENTITIES_PREDICATE));
            if (entityBadges.isEmpty()) continue;
            this.addTimedAppointmentsToView(DATE_KEY_FORMATTER.parse((String)apps.getKey()), (Iterable)entityBadges, calendar);
        }
        this.afterAddAppointments();
    }

    private static void addAppointment(ImmutableListMultimap.Builder<String, EntityBadge> appointments, EntityBadge appointment, Date startDate) {
        if (appointment == null || appointment.getStartAt() == null || appointment.getEndAt() == null) {
            return;
        }
        Object startAt = appointment.getStartAt();
        DateWithoutTimezone endAt = appointment.getEndAt();
        if (startAt.before(startDate)) {
            if (endAt != null && endAt.after(startDate)) {
                startAt = (Date)startDate.clone();
            } else {
                return;
            }
        }
        int differenceInDays = Dates.differenceInDays((Date)endAt, (Date)startAt);
        Object date = startAt;
        for (int i = 0; i <= differenceInDays; ++i) {
            if (!date.before(startDate)) {
                String strKey = DATE_KEY_FORMATTER.format((Date)date);
                appointments.put((Object)strKey, (Object)appointment);
                return;
            }
            date = Dates.getNextDay((Date)date);
        }
    }

    private static ImmutableListMultimap<String, EntityBadge> convertAppointmentToMap(Date startDate, Iterable<? extends EntityBadge> appointments) {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        if (appointments != null) {
            for (EntityBadge entityBadge : appointments) {
                CalendarView.addAppointment((ImmutableListMultimap.Builder)result, (EntityBadge)entityBadge, (Date)startDate);
            }
        }
        return result.build();
    }

    protected abstract Date getCurrentStartDate(Calendar var1);

    protected abstract Date getCurrentEndDate(Calendar var1);

    protected abstract void initView(Calendar var1);

    protected abstract void addWholeDaysAppointmentsToView(Date var1, @Nonnull Iterable<? extends EntityBadge> var2, Calendar var3);

    protected abstract void addTimedAppointmentsToView(Date var1, @Nonnull Iterable<? extends EntityBadge> var2, Calendar var3);

    protected abstract String getViewTitle(Calendar var1);

    protected void afterAddAppointments() {
    }

    protected boolean isMayCreateAppointment() {
        return this._mayCreate;
    }
}

