/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gwt.user.client.ui.tabs;

import com.freiheit.toro.client.event.EventListener;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import de.justsoftware.gwt.user.client.ui.tabs.TabbedView;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.ClientEvent;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.menu.presentation.client.model.ToggleLeftMenuStateClientEvent;
import javax.annotation.Nonnull;

public abstract class TabbedViewResizePresenter
implements TabbedView.Presenter {
    private static final int DEFAULT_RESIZE_TIMEOUT = 500;
    private HandlerRegistration _resizeHandlerRegistration;
    private final Timer _resizeTimer = new /* Unavailable Anonymous Inner Class!! */;
    private final EventManager.EventManagerHelper _eventManagerHelper;
    private final ClientFactory _clientFactory;

    public TabbedViewResizePresenter(@Nonnull ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._eventManagerHelper = new EventManager.EventManagerHelper(clientFactory.eventManager());
    }

    private void addResizeHandler() {
        EventListener resizeTimed = e -> this.handleContentResize(500);
        this._eventManagerHelper.registerListener(ToggleLeftMenuStateClientEvent.class, resizeTimed);
        this._resizeHandlerRegistration = this._clientFactory.addWindowResizeHandler(e -> this.handleContentResize(500));
    }

    protected void handleContentResize(int timeout) {
        this._resizeTimer.schedule(timeout);
    }

    public void onUnload() {
        this._eventManagerHelper.onUnloadRemoveHandlersFromManager();
        if (this._resizeHandlerRegistration != null) {
            this._resizeHandlerRegistration.removeHandler();
            this._resizeHandlerRegistration = null;
        }
        this._resizeTimer.cancel();
    }

    public void onLoad() {
        this.addResizeHandler();
    }

    protected <T extends ClientEvent> void registerListener(@Nonnull Class<T> clazz, @Nonnull EventListener<? super T> listener) {
        this._eventManagerHelper.registerListener(clazz, listener);
    }

    protected abstract void resizeView();
}

