/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gwt.requestcollect.server;

import com.google.common.collect.Maps;
import com.google.gwt.user.client.rpc.SerializationException;
import de.justsoftware.gwt.requestcollect.server.RequestCollectorGWTRPCServiceExporter;
import de.justsoftware.gwt.requestcollect.server.RequestCollectorRemoteServiceControl;
import de.justsoftware.gwt.requestcollect.shared.RequestCollectorNormalResult;
import de.justsoftware.gwt.requestcollect.shared.RequestCollectorRemoteService;
import de.justsoftware.gwt.requestcollect.shared.RequestCollectorRequest;
import de.justsoftware.gwt.requestcollect.shared.RequestCollectorResult;
import de.justsoftware.gwt.requestcollect.shared.RequestCollectorSerializableExceptionResult;
import de.justsoftware.gwt.requestcollect.shared.RequestCollectorStatus500Result;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestCollectorRemoteServiceImpl
implements RequestCollectorRemoteService,
RequestCollectorRemoteServiceControl {
    private static final Logger LOG = LoggerFactory.getLogger(RequestCollectorRemoteServiceImpl.class);
    private final Map<String, RequestCollectorGWTRPCServiceExporter> _remoteServices = Maps.newConcurrentMap();

    public RequestCollectorResult[] handleRequest(RequestCollectorRequest[] requests) {
        RequestCollectorResult[] result = new RequestCollectorResult[requests.length];
        for (int i = 0; i < requests.length; ++i) {
            result[i] = this.handleRequest(requests[i]);
        }
        return result;
    }

    @Nonnull
    private RequestCollectorResult handleRequest(@Nonnull RequestCollectorRequest request) {
        RequestCollectorGWTRPCServiceExporter serviceExporter = (RequestCollectorGWTRPCServiceExporter)this._remoteServices.get(request.getPath());
        if (serviceExporter == null) {
            String error = "Request blocked: No Service for path \"" + request.getPath() + "\" defined";
            LOG.error(error);
            return new RequestCollectorStatus500Result(error);
        }
        try {
            return new RequestCollectorNormalResult(serviceExporter.processCall(request.getRequestData()));
        }
        catch (SerializationException e) {
            LOG.error("Request blocked by SerializetionException: " + e.getMessage(), (Throwable)e);
            return new RequestCollectorSerializableExceptionResult();
        }
        catch (RuntimeException e) {
            LOG.error("Request blocked by an Exception: " + e.getMessage(), (Throwable)e);
            return new RequestCollectorStatus500Result("Request blocked by an Exception, see Server Error-Log");
        }
    }

    public void registerRemoteService(String urlPath, RequestCollectorGWTRPCServiceExporter handler) {
        if (!(handler.getService() instanceof RequestCollectorRemoteService)) {
            this._remoteServices.put(urlPath, handler);
        }
    }
}

