/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.auth;

import com.freiheit.toro.common.presentation.ui.HTMLUtil;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

@ParametersAreNonnullByDefault
public class OAuthAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private static final String LAST_USERNAME_KEY = "LAST_USERNAME";

    public OAuthAuthenticationFailureHandler(String failureUrl) {
        super.setDefaultFailureUrl(failureUrl);
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String lastUserName = HTMLUtil.htmlEscape((String)request.getParameter("j_username"));
        HttpSession session = request.getSession(false);
        if (session != null || this.isAllowSessionCreation()) {
            request.getSession().setAttribute(LAST_USERNAME_KEY, (Object)lastUserName);
        }
        super.onAuthenticationFailure(request, response, exception);
    }
}

