<!DOCTYPE html>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
        <link rel="preload" as="style" href="/just-client-libs/bundles/just-client-libs.bundle.css">
        <link rel="stylesheet" href="/just-client-libs/bundles/just-client-libs.bundle.css">
        <style>
            html {
                height: 100%;
            }

            body {
                font-family: "Open Sans";
                font-size: 16px;
                font-weight: 300;
                color: ${textColor};
                background-color: ${backgroundGradientStartColor};
                min-height: 100%;
                margin: 0;
                padding: 10% 24px;
                box-sizing: border-box;
                opacity: 0;
                transition: opacity .3s ease-in-out;
            }

            .login {
                margin: 0 auto;
                max-width: 350px;
            }

            .login-header {
                font-weight: bold;
                margin-top: 20px;
                margin-bottom: 27px;
            }

            .logo {
                background-image: url(${logo});
                background-position: center;
                background-repeat: no-repeat;
                background-size: contain;
                width: 100%;
                height: 50px;
                margin-bottom: 55px;
            }

            .login-form input {
                box-sizing: border-box;
                width: 100%;
                -webkit-appearance: none;
                -moz-appearance: none;
                appearance: none;
            }

            .login-form input:focus {
                outline: none;
            }

            .login-form input[type="text"],
            .login-form input[type="password"] {
                border: 1px solid ${textColor};
                border-radius: 4px;
                margin-bottom: 24px;
                padding: 0 8px;
                height: 40px;
                background: #ffffff;
                color: #404040;
                font-size: 16px;
                font-weight: 300;

                ::placeholder { /* Chrome, Firefox, Opera, Safari 10.1+ */
                  color: #9f9f9f;
                  opacity: 1; /* Firefox */
                }

                ::-ms-input-placeholder { /* Microsoft Edge */
                  color: #9f9f9f;
                }
            }

            .login-form input[type="submit"] {
                border: none;
                border-radius: 4px;
                padding: 5px;
                height: 40px;
                background-color: ${buttonBackgroundColor};
                color: ${buttonTextColor};
                font-size: 16px;
                font-weight: 600;
                cursor: pointer;
            }

            .login-form.auth-error input[type="text"],
            .login-form.auth-error input[type="password"] {
                border-color: #C11515;
            }

            .auth-error {
                color: #C11515;
                margin-bottom: 24px;
            }

            .hidden {
                display: none;
            }

            .password-container, .username-container {
                position: relative;
            }

            #password, #username {
                padding-right: 32px;
            }

            #toggle-password, #clear-username {
                color: #404040;
                position: absolute;
                top: 0;
                right: 0;
                padding: 12px 8px;
            }
        </style>
    </head>
    <body id="body">
        <div class="login">
            <div class="login-header">
                <div class="logo"></div>
                <h1><@trans key="LoginConstants.loginHeader" /></h1>
            </div>
            <form id="login-form" class="login-form<#if authError??> auth-error</#if>" action="${loginAction}" method="POST">
                <div class=username-container>
                    <input
                        type="text"
                        id="username"
                        name="j_username"
                        <#if LAST_USERNAME??> value="${LAST_USERNAME}" </#if>
                        placeholder="<@trans key="LoginConstants.userNamePlaceholder" />" />
                    <i class="fal fa-times" id="clear-username"></i>
                </div>
                <div class="password-container">
                    <input type="password" id="password" name="j_password" placeholder="<@trans key="LoginConstants.passwordPlaceholder"/>" />
                    <i class="fal fa-eye-slash" id="toggle-password"></i>
                </div>
                <#if authError??>
                    <div id="error-message" class="auth-error"><@trans key="LoginConstants.genericError" /></div>
                </#if>
                <input type="submit" value="<@trans key="LoginConstants.loginButton"/>" />
            </form>
        </div>
        <script>
            window.onload = function() {
                document.getElementById("body").style.opacity = "1";
            }
        </script>
        <script>
            const form = document.querySelector("#login-form");
            const errorMessage = document.querySelector("#error-message");
            const togglePassword = document.querySelector("#toggle-password");
            const password = document.querySelector("#password");
            const clearUsername = document.querySelector("#clear-username");
            const username = document.querySelector("#username");

            form.addEventListener("focus", (event) => {
                form.classList.remove("auth-error");
                errorMessage.classList.add("hidden");
            }, true);

            togglePassword.addEventListener("click", () => {
                const type = password.getAttribute("type") === "password" ? "text" : "password";
                password.setAttribute("type", type);

                togglePassword.classList.toggle("fa-eye");
                togglePassword.classList.toggle("fa-eye-slash");
            });

            function conditionallyShowClearUsername(username, clearUsername) {
                clearUsername.style.display = username.value ? "block" : "none";
            }

            function conditionallyShowTogglePassword(password, togglePassword) {
                togglePassword.style.display = password.value ? "block" : "none";
            }

            clearUsername.addEventListener("click", () => {
                username.value = "";
                conditionallyShowClearUsername(username, clearUsername);
            });

            password.addEventListener("input", () => conditionallyShowTogglePassword(password, togglePassword));
            username.addEventListener("input", () => conditionallyShowClearUsername(username, clearUsername));

            conditionallyShowClearUsername(username, clearUsername);
            conditionallyShowTogglePassword(password, togglePassword);
        </script>
    </body>
</html>
