/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.topnews.presentation.client.impl;

import com.freiheit.toro.account.presentation.ui.StartPageHandler;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.gwt.i18n.dynamic.client.LocaleInfo;
import de.justsoftware.onx.common.presentation.client.ui.EntityComponentHandler;
import de.justsoftware.onx.common.presentation.client.ui.JustNativeApp;
import de.justsoftware.onx.common.presentation.client.ui.JustNativeAppWidget;
import de.justsoftware.onx.common.shared.model.StartpageId;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.news.business.LinkToChannel;
import de.justsoftware.onx.news.business.LinkToPost;
import de.justsoftware.onx.news.business.NewsComponentProps;
import de.justsoftware.onx.topnews.presentation.client.TopNewsClientFactory;
import de.justsoftware.onx.topnews.presentation.client.impl.TopNewsEntityComponentHandler;
import de.justsoftware.onx.topnews.presentation.client.ui.TopNewsComponent;
import de.justsoftware.onx.workstream.presentation.client.ui.WorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TopNewsClientFactoryImpl
implements TopNewsClientFactory {
    public EntityComponentHandler componentHandler() {
        return new TopNewsEntityComponentHandler();
    }

    public IsWidget createTopNewsWidget(EntityDetails entityDetails) {
        EntityId entityId = entityDetails.getId();
        return this.createWidget((GlobalId)entityId);
    }

    public IsWidget createStartPageTopNewsWidget(StartpageId startpageId) {
        return this.createWidget((GlobalId)startpageId);
    }

    private IsWidget createWidget(GlobalId id) {
        TopNewsComponent component = new TopNewsComponent();
        String locale = LocaleInfo.getCurrentLocaleName();
        NewsComponentProps props = NewsComponentProps.createWithChannelId((String)id.asString(), null, (String)locale, (LinkToChannel)this.getLinkToChannel(), (LinkToPost)this.getLinkToPost(), (String)this.getLinkToFeed());
        return new JustNativeAppWidget((JustNativeApp)component, (JustNativeApp.JustAppProps)props);
    }

    private LinkToChannel getLinkToChannel() {
        return channelId -> {
            EntityId parsedChannelId = EntityId.parse((String)channelId);
            if (parsedChannelId != null) {
                return EntityOverviewHandler.token((EntityId)parsedChannelId);
            }
            return "";
        };
    }

    private LinkToPost getLinkToPost() {
        return postId -> {
            WorkstreamMessageId workstreamMessageId = WorkstreamMessageId.parse((String)postId);
            if (workstreamMessageId != null) {
                return WorkstreamMessageHandler.token((WorkstreamMessageId)workstreamMessageId);
            }
            return "";
        };
    }

    private String getLinkToFeed() {
        return StartPageHandler.token();
    }
}

