/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.WaitSpinner;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyDetailsHandler;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyResultWidget;
import de.justsoftware.onx.survey.shared.i18n.SurveyConstants;
import de.justsoftware.onx.survey.shared.i18n.SurveyMessages;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.survey.shared.model.DBSurveyQuestion;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.survey.shared.model.SurveyResult;
import de.justsoftware.onx.survey.shared.model.SurveyResultVisibility;
import de.justsoftware.onx.survey.shared.model.SurveyTeaser;
import java.util.List;
import javax.annotation.Nonnull;

public class SurveyResultWidget
extends Composite {
    private static final SurveyConstants SURVEY = I18nMediator.SURVEY;
    private static final SurveyMessages SURVEY_MSG = I18nMediator.SURVEY_MSG;
    private static final int PARTICIPANT_SHORT_VIEW_COUNT = 4;
    private static final int FREETEXT_SHORT_VIEW_COUNT = 4;
    private static final SurveyQuestionResultWidgetUIBinder SURVEY_QUESTION_RESULT_WIDGET_UI_BINDER = (SurveyQuestionResultWidgetUIBinder)GWT.create(SurveyQuestionResultWidgetUIBinder.class);
    private static final SurveyResultWidgetUIBinder SURVEY_RESULT_WIDGET_UI_BINDER = (SurveyResultWidgetUIBinder)GWT.create(SurveyResultWidgetUIBinder.class);
    @UiField
    FlowPanel _resultPanel;
    @UiField
    WaitSpinner _waitIcon;
    private final ClientFactory _clientFactory;

    public SurveyResultWidget(SurveyTeaser survey, ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this.initWidget((Widget)SURVEY_RESULT_WIDGET_UI_BINDER.createAndBindUi((Object)this));
        this.setSurveyTeaser(survey);
    }

    public void setSurveyTeaser(SurveyTeaser survey) {
        boolean hasParticipate;
        this._resultPanel.clear();
        boolean bl = hasParticipate = !CollectionUtil.isEmpty((Iterable)survey.getCurrentUserAnswers());
        if (!survey.getAllowedActions().contains((Object)StaticAction.SURVEY_READ) || !survey.getAllowedActions().contains((Object)StaticAction.SURVEY_READ_RESULT)) {
            if (hasParticipate) {
                this._resultPanel.add((Widget)new Label(SURVEY.youHaveParticipated()));
            } else {
                this._resultPanel.add((Widget)new Label(SURVEY.youDontHaveParticipated()));
            }
            DBSurvey surveyData = survey.getSurveyData();
            if (surveyData != null && SurveyResultVisibility.ADMIN_ONLY.equals((Object)surveyData.getResultVisibility())) {
                this._resultPanel.add((Widget)new Label(SURVEY.resultOnlyForAdminVisible()));
            }
            this._resultPanel.add((Widget)new Hyperlink(hasParticipate ? SURVEY.displayMyAnswersLabel() : SURVEY.displaySurveyQuestions(), SurveyDetailsHandler.token((SurveyId)survey.getSurveyId(), (boolean)true)));
        } else {
            this._waitIcon.setVisible(true);
            this._clientFactory.surveyClientFactory().controller().getSurveyResultById(survey.getSurveyId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void setSurveyResult(@Nonnull SurveyTeaser survey, @Nonnull SurveyResult surveyResult) {
        this._resultPanel.clear();
        DBSurvey surveyData = survey.getSurveyData();
        if (surveyResult.getAnswerResults().isEmpty() || CollectionUtil.isEmpty((Iterable)surveyData.getQuestions())) {
            this._resultPanel.add((Widget)new Label(SURVEY.noAnswersForThisSurvey()));
            return;
        }
        for (DBSurveyQuestion question : surveyData.getQuestions()) {
            int questionCount = surveyResult.getQuestionParticipantCounts().count((Object)question.getId());
            this._resultPanel.add((Widget)new SurveyQuestionResult(question, (List)surveyResult.getAnswerResults().get((Object)question.getId()), questionCount));
        }
    }
}

