/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.common.presentation.ui.HTMLUtil;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.InlineHyperlink;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.FieldNameResolver;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.searchnew.presentation.client.SearchTrackingInfo;
import de.justsoftware.onx.searchnew.presentation.client.ui.BaseSearchResultBadgePresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.WikiSearchResultBadgePresenter;
import de.justsoftware.onx.searchnew.shared.model.WikiSearchResultBadgeModel;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class WikiSearchResultBadgePresenter
extends BaseSearchResultBadgePresenter {
    public WikiSearchResultBadgePresenter(ClientFactory clientFactory, WikiSearchResultBadgeModel model, boolean displayParents, boolean displayContextSwitch, @Nullable SearchTrackingInfo searchTrackingInfo, @Nullable String additionalOverlayStyleName) {
        super(clientFactory, displayContextSwitch, (SearchableId)model.getId(), searchTrackingInfo, additionalOverlayStyleName);
        this.setIcon(model);
        this.setTitle(model);
        this._view.setParentEnabled(displayParents);
        this.setLastChangeDate(model.getModifyDate());
        this._view.addFoundIn((Collection)model.getFoundInFields(), (FieldNameResolver)WikiFieldNameResolver.INSTANCE);
    }

    private void setTitle(WikiSearchResultBadgeModel model) {
        String targetHistoryToken = this.token(model);
        String name = model.getName();
        if (name != null) {
            InlineHyperlink link = new InlineHyperlink(name, targetHistoryToken);
            link.setHTML(HTMLUtil.highlightedHtmlEscape((String)name));
            link.setTitle(HTMLUtil.removeHighlightTag((String)name));
            this._view.setTitleWidget(link);
        }
    }

    @Nonnull
    private String token(WikiSearchResultBadgeModel model) {
        return "/wiki/wikis/" + model.getId();
    }

    private void setIcon(WikiSearchResultBadgeModel model) {
        Hyperlink icon = new Hyperlink("", this.token(model));
        icon.addStyleName("fa");
        icon.addStyleName("fa-book-open");
        icon.addStyleName("action");
        icon.addStyleName("badgeIcon");
        icon.addStyleName("app-wiki-color");
        icon.setTitle(HTMLUtil.removeHighlightTag((String)model.getName()));
        this._view.setIconWidget((Widget)icon);
    }
}

