/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasWidgets;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.searchnew.presentation.client.SearchClientFactory;
import de.justsoftware.onx.searchnew.presentation.client.SearchHandler;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchHeadlinePresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.SearchHeadlineView;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeVisitor;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProvider;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class SearchHeadlinePresenter
implements SearchHeadlineView.Presenter {
    private static final ImmutableSet<SearchContext> LOADING_NAME_NEEDED = ImmutableSet.of((Object)SearchContext.ENTITY_AND_SUBENTITIES, (Object)SearchContext.ENTITY);
    private final SearchHeadlineView _view;
    private final SearchClientFactory _searchFactory;

    public SearchHeadlinePresenter(@Nonnull SearchClientFactory searchFactory) {
        this._view = searchFactory.createSearchHeadlineView();
        this._searchFactory = searchFactory;
    }

    public void update(SearchParameters searchParameters) {
        EntityId entityId = searchParameters.getContextEntityId();
        if (entityId != null && LOADING_NAME_NEEDED.contains((Object)searchParameters.getSearchContext())) {
            EntityMediator.getInstance().getInfoById(entityId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.update(searchParameters, null);
        }
    }

    private void update(@Nonnull SearchParameters searchParameters, @Nullable EntityInfo result) {
        this._view.clear();
        String entityName = result != null ? result.getName() : I18nMediator.SEARCH.unknownEntity();
        SearchParameters allParameter = searchParameters.withSearchContext(SearchContext.ENTIRE_PLATFORM).withSearchProvider(SearchProvider.JUCO_PROVIDER);
        this.addHeadline(SearchHeadlinePresenter.getTextFor((SearchParameters)allParameter, (String)entityName), allParameter, searchParameters);
        SearchParameters myContentParameter = SearchHeadlinePresenter.getMyContentContext((SearchParameters)searchParameters).withSearchProvider(SearchProvider.JUCO_PROVIDER);
        this.addHeadline(SearchHeadlinePresenter.getTextFor((SearchParameters)myContentParameter, (String)entityName), myContentParameter, searchParameters);
        boolean useExternalSearchProvider = HostPropertiesMediator.getHostPropertiesBean().isUseExternalSearchProvider();
        if (useExternalSearchProvider) {
            this._searchFactory.getAvailableSearchProvider((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected void addHeadline(@Nonnull String label, @Nonnull SearchParameters newParameters, @Nonnull SearchParameters currentParameters) {
        if (currentParameters.isEqualTo(newParameters)) {
            this._view.addHeadlineLabel(label);
        } else {
            this._view.addHeadlineLink(label, SearchHandler.tokenFor((SearchParameters)newParameters));
        }
    }

    @Nonnull
    private static SearchParameters getMyContentContext(@Nonnull SearchParameters searchParameters) {
        if (StaticFilterType.PROFILES.equals((Object)searchParameters.getFilterType())) {
            return searchParameters.withFilter((FilterType)StaticFilterType.ALL).withSearchContext(SearchContext.MY_CONTENT);
        }
        return searchParameters.withSearchContext(SearchContext.MY_CONTENT);
    }

    @Nonnull
    private static String getTextFor(@Nonnull SearchParameters searchParameters, @Nonnull String entityName) {
        FilterTypeVisitor visitor = (FilterTypeVisitor)searchParameters.getSearchContextOrEntirePlatform().accept((SearchContext.Visitor)new FilterTypeVisitorForSearchContextVisitor(entityName));
        return (String)searchParameters.getFilterTypeOrAll().accept(visitor);
    }

    public void appendView(HasWidgets parent) {
        parent.add(this._view.asWidget());
    }

    public SearchHeadlineView getView() {
        return this._view;
    }
}

