/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import de.justsoftware.onx.searchnew.presentation.client.MultiSelectionFilterLink;
import de.justsoftware.onx.searchnew.presentation.client.ui.AbstractMultiSelectionDataProvider;
import de.justsoftware.onx.searchnew.presentation.client.ui.MultipleSelectionFilterPresenter;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilterSelector;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class AbstractMultiSelectionDataProvider<T>
implements MultipleSelectionFilterPresenter.MultiSelectionFilterLinkDataProvider<T> {
    private final SearchConfigurationProvider _searchConfigurationProvider;

    public AbstractMultiSelectionDataProvider(SearchConfigurationProvider searchConfigurationProvider) {
        this._searchConfigurationProvider = searchConfigurationProvider;
    }

    public boolean isFilterApplicable(SearchParameters searchParameters) {
        return searchParameters.getFilterTypeOrAll().equals(StaticFilterType.ALL) && this.getSearchFacet().applyWithoutFilterType(this._searchConfigurationProvider) || this.getSearchFacet().applyForFilterType(this._searchConfigurationProvider).apply((Object)searchParameters.getFilterType());
    }

    public ImmutableList<MultiSelectionFilterLink<T>> getFilterLinks(SearchParameters searchParameters, SearchResult<FederatedSearchResultEntry> result) {
        SearchFacetCounts facetCount = result.getFacetCount(this.getSearchFacet());
        if (facetCount == null) {
            return ImmutableList.of();
        }
        return (ImmutableList)facetCount.accept(this.getSearchFacetCountsVisitor(searchParameters));
    }

    public SearchParameters onSelectionChanged(T selection, boolean selected, SearchParameters searchParameters) {
        return searchParameters.withSubfilters((Set)this.getSkipCurrentSubFilterSelector().on((Set)searchParameters.getSubfilter())).withAdditionalSubfilter(this.createSubfilter(this.createNewSelection(selection, selected, searchParameters)));
    }

    public SearchParameters onSelectionsCleared(SearchParameters searchParameters) {
        return searchParameters.withSubfilters((Set)this.getSkipCurrentSubFilterSelector().on((Set)searchParameters.getSubfilter()));
    }

    @Nonnull
    protected ImmutableSet<T> createNewSelection(T selection, boolean selected, SearchParameters searchParameters) {
        if (selected) {
            ImmutableSet.Builder newValuesBuilder = ImmutableSet.builder();
            newValuesBuilder.addAll((Iterable)this.getCurrentlySelected(searchParameters));
            newValuesBuilder.add(selection);
            return newValuesBuilder.build();
        }
        return ImmutableSet.copyOf((Collection)Sets.difference((Set)this.getCurrentlySelected(searchParameters), (Set)ImmutableSet.of(selection)));
    }

    public boolean isRestrictionSelected(SearchParameters searchParameters) {
        return !this.getCurrentlySelected(searchParameters).isEmpty();
    }

    public Ordering<? super MultiSelectionFilterLink<T>> getSelectedFilterOrdering(SearchResult<FederatedSearchResultEntry> result) {
        SearchFacetCounts facetCount = result.getFacetCount(this.getSearchFacet());
        if (facetCount == null) {
            return null;
        }
        switch (2.$SwitchMap$de$justsoftware$onx$searchnew$shared$model$SearchFacetCounts$FacetSortType[facetCount.getSortType().ordinal()]) {
            case 1: {
                return Ordering.natural().nullsFirst().onResultOf(MultiSelectionFilterLink.TO_LABEL);
            }
        }
        return null;
    }

    @Nonnull
    protected abstract SearchFacetCounts.SearchFacetCountsVisitor<ImmutableList<MultiSelectionFilterLink<T>>> getSearchFacetCountsVisitor(SearchParameters var1);

    @Nonnull
    protected abstract SearchFacet getSearchFacet();

    @Nonnull
    protected abstract ImmutableSet<T> getCurrentlySelected(SearchParameters var1);

    @Nonnull
    protected abstract SubFilter createSubfilter(ImmutableSet<T> var1);

    @Nonnull
    protected abstract SubFilterSelector getSkipCurrentSubFilterSelector();

    @Nonnull
    protected MultipleSelectionFilterPresenter.SearchInSelectionsSupport<T> createDefaultSearchInSelectionSupport() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

