/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client;

import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.components.presentation.client.ui.HolmesService;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.searchnew.shared.model.CompoundIdStringUtil;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchTrackingAction;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SearchTrackingInfo {
    private final String _searchId;
    private final String _previousSearchId;
    private final SearchParameters _searchParameters;
    private final int _offset;
    private final ImmutableList<SearchableId> _searchResult;
    private final int _numberOfResults;

    public SearchTrackingInfo(String searchId, @Nullable String previousSearchId, SearchParameters searchParameters, int offset, List<SearchableId> searchResult, int numberOfResults) {
        this._searchId = searchId;
        this._previousSearchId = previousSearchId;
        this._searchParameters = searchParameters;
        this._offset = offset;
        this._searchResult = ImmutableList.copyOf(searchResult);
        this._numberOfResults = numberOfResults;
    }

    @Nonnull
    public String getSearchId() {
        return this._searchId;
    }

    @Nonnull
    public SearchParameters getSearchParameters() {
        return this._searchParameters;
    }

    @Nonnull
    public HolmesService.TrackingPayload addTrackingPayloadData(HolmesService.TrackingPayload payload, SearchTrackingAction type, @Nullable SearchableId selected) {
        payload.set("action", type.name()).set("searchId", this._searchId.toString()).set("previousSearchId", this._previousSearchId).set("searchQuery", this._searchParameters.getText()).set("sortType", (Enum)this._searchParameters.getSortType()).set("typeFilter", this._searchParameters.getFilterTypeOrAll().getName()).set("offset", this._offset).set("numberOfResults", this._numberOfResults);
        if (selected != null) {
            int searchResultPosition = this._searchResult.indexOf((Object)selected);
            searchResultPosition = searchResultPosition >= 0 ? searchResultPosition + this._offset : -1;
            payload.set("searchResultId", CompoundIdStringUtil.getCompoundIdSearchStringFromSearchableId((SearchableId)selected)).set("searchResultPosition", searchResultPosition);
        }
        return payload;
    }
}

