/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.presentation.shared.CommonSearchRemoteService;
import de.justsoftware.onx.searchnew.presentation.shared.CommonSearchRemoteServiceAsync;
import de.justsoftware.onx.searchnew.shared.model.EntitySuggest;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.PersonSuggest;
import de.justsoftware.onx.searchnew.shared.model.SearchContextModel;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SuggestModel;
import java.util.Collection;

public final class CommonSearchMediator
implements CommonSearchRemoteServiceAsync {
    private static final CommonSearchMediator INSTANCE = new CommonSearchMediator();
    private final CommonSearchRemoteServiceAsync _service = (CommonSearchRemoteServiceAsync)GWT.create(CommonSearchRemoteService.class);

    private CommonSearchMediator() {
        UrlUtil.setRemoteServiceUrl((Object)this._service, (String)"/searchCommon");
    }

    public static CommonSearchMediator getInstance() {
        return INSTANCE;
    }

    public void suggest(String searchString, SearchContextModel searchContext, Collection<SubFilter> additionalFilter, ImmutableSet<FilterType> filterTypes, SortType selectedSortType, int offset, int numberOfResults, AsyncCallback<SearchResult<SuggestModel<?, ?>>> callback) {
        this._service.suggest(searchString, searchContext, additionalFilter, filterTypes, selectedSortType, offset, numberOfResults, callback);
    }

    public void suggestEntities(String searchString, ImmutableSet<EntityType> searchTypes, int offset, int numberOfResults, AsyncCallback<SearchResult<EntitySuggest>> callback) {
        this._service.suggest(searchString, null, null, ImmutableSet.copyOf((Iterable)Iterables.transform(searchTypes, (Function)FilterTypes.GET_BY_TYPE)), null, offset, numberOfResults, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void suggestReviewerForEntity(EntityId entityId, String searchString, int reviewStage, int offset, int numberOfResults, AsyncCallback<SearchResult<SuggestModel<?, ?>>> callback) {
        this._service.suggestReviewerForEntity(entityId, searchString, reviewStage, offset, numberOfResults, callback);
    }

    public void suggestAuthorForEntity(EntityId entityId, String searchString, int offset, int numberOfResults, AsyncCallback<SearchResult<SuggestModel<?, ?>>> callback) {
        this._service.suggestAuthorForEntity(entityId, searchString, offset, numberOfResults, callback);
    }

    public void getPotentialReviewersForEntity(EntityId entityId, int reviewStage, int offset, int numberOfResults, AsyncCallback<ListAndCount<PersonSuggest>> callback) throws ServiceException {
        this._service.getPotentialReviewersForEntity(entityId, reviewStage, offset, numberOfResults, callback);
    }

    public void getPotentialAuthorsForEntity(EntityId entityId, int offset, int numberOfResults, AsyncCallback<ListAndCount<PersonSuggest>> callback) {
        this._service.getPotentialAuthorsForEntity(entityId, offset, numberOfResults, callback);
    }
}

