/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client.ui;

import com.freiheit.toro.client.mediator.Callback;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JCDialogBox;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.presentation.client.ui.InviteAsFriendWidget;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InviteAsFriendWidget
extends JCDialogBox {
    private static final ProfileConstants PROFILE = I18nMediator.PROFILE;
    private static final InviteAsFriendWidgetUIBinder UI_BINDER = (InviteAsFriendWidgetUIBinder)GWT.create(InviteAsFriendWidgetUIBinder.class);
    private final InviteAsFriendWidgetContent _inviteAsFriendContent = new InviteAsFriendWidgetContent(this);
    private final PersonId _friendId;
    private final Callback _onOkCallback;
    private final JCButton _okButton = new JCButton(I18nMediator.PROFILE.askForContact());
    private final JCButton _cancelButton = new JCButton(I18nMediator.BASIC_CONSTANTS.cancel());

    public InviteAsFriendWidget(@Nonnull PersonId friendId, @Nullable Callback onOkCallback) {
        this._friendId = friendId;
        this._onOkCallback = onOkCallback;
        this._okButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._cancelButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.addButton(this._okButton);
        this.addButton(this._cancelButton);
        this.setText(PROFILE.reallyAskForContact());
        this.setContent((IsWidget)this._inviteAsFriendContent);
    }

    private void onShowHideMessage() {
        if (this._inviteAsFriendContent._message.isVisible()) {
            this._inviteAsFriendContent._message.setVisible(false);
            this._inviteAsFriendContent._showHideMessage.setText(PROFILE.contactMessageAdd());
        } else {
            this._inviteAsFriendContent._message.setVisible(true);
            this._inviteAsFriendContent._showHideMessage.setText(PROFILE.contactMessageRemove());
        }
    }

    private void onCancel() {
        this.hide();
    }

    private void onOk() {
        String message = this._inviteAsFriendContent._message.isVisible() ? this._inviteAsFriendContent._message.getText() : null;
        this._okButton.setEnabled(false);
        this._cancelButton.setEnabled(false);
        ClientFactoryImpl.INSTANCE.personClientFactory().friendsController().invitePerson(this._friendId, message, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

