/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.context.AppContext;
import de.justsoftware.onx.person.presentation.client.AccountSettingsPresenter;
import de.justsoftware.onx.person.presentation.client.PersonMediator;
import de.justsoftware.onx.person.presentation.client.SectionExpandClickHandler;
import de.justsoftware.onx.person.presentation.client.SectionHasChangesHandler;
import de.justsoftware.onx.person.presentation.client.ui.AccountSettingsSection;
import de.justsoftware.onx.person.presentation.client.ui.AccountSettingsTabViewImpl;
import de.justsoftware.onx.person.presentation.client.ui.MailNotificationSettingsViewImpl;
import de.justsoftware.onx.person.shared.model.EmailNotificationSettingsBean;
import java.util.List;
import javax.annotation.Nonnull;

public class MailNotificationSettingsPresenter
implements AccountSettingsPresenter.SettingsPresenter {
    private static final BasicConstants BASIC_CONSTANTS = I18nMediator.BASIC_CONSTANTS;
    private EmailNotificationSettingsBean _emailNotificationSettings;
    private final AccountSettingsPresenter.AccountSettingsTabView _view = new AccountSettingsTabViewImpl();
    private final PersonId _personId;

    public MailNotificationSettingsPresenter(@Nonnull PersonId personId, @Nonnull HasWidgets container) {
        this._personId = personId;
        this.updateModels();
        container.add(this._view.asWidget());
    }

    private void initGUI() {
        this._view.removeAllSections();
        if (this._emailNotificationSettings.isEmailNotificationsVisible()) {
            this.addMailNotificationSection();
        }
        for (AccountSettingsSection section : this._view.getSections()) {
            section.expand(this._view.getSections().size() == 1);
            section.addExpandClickHandler((ClickHandler)new SectionExpandClickHandler(section, this._view.getSections()));
            section.setCancelClickHandler(event -> {
                this.updateModels();
                section.expandAndReset(this._view.getSections().size() <= 1);
            });
        }
    }

    private void updateModels() {
        this.loadMailNotifactionSettings((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadMailNotifactionSettings(@Nonnull AsyncCallback<EmailNotificationSettingsBean> callback) {
        PersonMediator.getInstance().getEmailNotificationSettings(this._personId, callback);
    }

    private void addMailNotificationSection() {
        this._view.addSection(BASIC_CONSTANTS.emailNotificationSettings(), arg_0 -> this.fillMailNotificationSection(arg_0));
    }

    private void fillMailNotificationSection(AccountSettingsSection mailNotificationSection) {
        MailNotificationSettingsViewImpl view = new MailNotificationSettingsViewImpl();
        view.addSectionHasChangesHandler((ValueChangeHandler)new SectionHasChangesHandler(mailNotificationSection));
        view.setEmailNotificationConcernMe(this._emailNotificationSettings.isEmailNotificationConcernMe());
        view.setEmailNotificationConcernMeVisible(this._emailNotificationSettings.isEmailNotificationsVisible());
        String emailNotificationConcernMeHtml = BASIC_CONSTANTS.emailOtherNotifications();
        view.setEmailNotificationConcernMeHtml(emailNotificationConcernMeHtml);
        view.setChatEmailNotificationEnabled(this._emailNotificationSettings.isChatEmailNotificationEnabled());
        view.setChatEmailNotificationVisible(this._emailNotificationSettings.isEmailNotificationsVisible() && AppContext.isAppAvailable((CoreApp)CoreApp.CONVERSATIONS));
        view.setChatEmailNotificationHtml(BASIC_CONSTANTS.emailChatNotifications());
        mailNotificationSection.setContent((IsWidget)view);
        mailNotificationSection.setSaveClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<AccountSettingsSection> getSections() {
        return this._view.getSections();
    }
}

