/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.multiwiki.presentation.server.impl;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.multiwiki.business.MultiWikiService;
import de.justsoftware.onx.multiwiki.presentation.shared.MultiWikiController;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiClientModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiId;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiSectionEditModel;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MultiWikiControllerImpl
implements MultiWikiController {
    @Autowired
    private MultiWikiService _multiWikiService;
    @Autowired
    private SessionAuthorizationContextProvider _sessionAuthorizationContextProvider;

    public MultiWikiClientModel loadCurrentWiki(MultiWikiId wikiId, String viewAsMemberOfRole) throws ServiceException {
        AuthorizationContext currentUserAuthCtx = this._sessionAuthorizationContextProvider.getAuthorizationContextForCurrentUser();
        try {
            return this._multiWikiService.getCurrentWiki(wikiId, viewAsMemberOfRole, (AuthorizationCheckContextWithUserId)currentUserAuthCtx);
        }
        catch (InvalidIDException e) {
            throw new InvalidIdServiceException(e.getMessage());
        }
        catch (ServiceException e) {
            throw new ServiceException(e.getMessage());
        }
    }

    public MultiWikiClientModel saveMultiWiki(MultiWikiId wikiId, MultiWikiVersionId currentVersion, ImmutableList<MultiWikiSectionEditModel> sections) {
        AuthorizationContext auth = this._sessionAuthorizationContextProvider.getAuthorizationContextForCurrentUser();
        try {
            this._multiWikiService.saveMultiWiki(wikiId, currentVersion, sections, (AuthorizationCheckContextWithUserId)auth);
            return this._multiWikiService.getCurrentWiki(wikiId, null, (AuthorizationCheckContextWithUserId)auth);
        }
        catch (InvalidIDException e) {
            throw new InvalidIdServiceException(e.getMessage());
        }
    }
}

