/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.hierarchy.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.hierarchy.shared.model.EntityTreeItemData;
import java.util.Comparator;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class EntityTreeItem
implements Comparable<EntityTreeItem> {
    public static final Ordering<EntityTreeItem> ORDER = Ordering.from((Comparator)I18nMediator.LOCALIZED_MESSAGES.localizedComparator()).onResultOf((Function)new /* Unavailable Anonymous Inner Class!! */).compound((Comparator)Ordering.natural().nullsLast().onResultOf(GlobalId.TO_LONG).onResultOf((Function)new /* Unavailable Anonymous Inner Class!! */));
    private final EntityTreeItemData _data;
    private final TreeSet<EntityTreeItem> _children = new TreeSet();
    private boolean _childLoaded;

    public EntityTreeItem(EntityTreeItemData data) {
        this._data = data;
        this.addAllChilds((Iterable)this._data.getChilds());
        this._childLoaded = false;
    }

    public String getName() {
        return this._data.getEntity().getName();
    }

    @CheckForNull
    private String getLowercaseName() {
        String name = this.getName();
        return name != null ? name.toLowerCase() : null;
    }

    public int getChildCount() {
        return this._data.getChildCount();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getName().toLowerCase()});
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof EntityTreeItem && this.compareTo((EntityTreeItem)obj) == 0;
    }

    @Override
    public int compareTo(EntityTreeItem o) {
        return ORDER.compare((Object)this, (Object)o);
    }

    public void addChild(@Nonnull EntityTreeItem i) {
        this._children.add(i);
    }

    private void addAllChilds(@Nonnull Iterable<EntityTreeItemData> childData) {
        for (EntityTreeItemData data : childData) {
            this.addChild(new EntityTreeItem(data));
        }
    }

    @Nonnull
    public TreeSet<EntityTreeItem> getChildren() {
        return this._children;
    }

    public boolean isChildLoaded() {
        return this._childLoaded;
    }

    public EntityTreeItemData getData() {
        return this._data;
    }

    public EntityId getId() {
        return (EntityId)this._data.getEntity().getId();
    }

    public void addAllLoadedChilds(ImmutableList<EntityTreeItemData> result) {
        this.addAllChilds(result);
        this._childLoaded = true;
    }
}

