/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.hierarchy.presentation.client.ui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.components.presentation.client.ui.WidgetList;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.hierarchy.presentation.client.ui.DynamicEntityTreeItem;
import de.justsoftware.onx.hierarchy.presentation.client.ui.EntityTreeItem;
import de.justsoftware.onx.hierarchy.shared.model.EntityTreeData;
import de.justsoftware.onx.hierarchy.shared.model.EntityTreeItemData;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DynamicEntityTreeWidget {
    final LinkedListMultimap<EntityId, DynamicEntityTreeItem> _itemsByEntityId = LinkedListMultimap.create();
    final ImmutableSet<EntityType> _treeEntityTypes;
    final ImmutableSet<EntityId> _fixedItems;
    private EntityId _currentSelectedEntityId;
    private final Set<EntityTreeItem> _rootEntityTreeItems = Sets.newTreeSet();
    private final Map<EntityTreeItem, DynamicEntityTreeItem> _rootItems = Maps.newHashMap();
    private final WidgetList _content;
    private boolean _rootNeedsRebuild = false;
    private final Set<DynamicEntityTreeItem> _itemsToRebuild = Sets.newHashSet();

    public DynamicEntityTreeWidget(@Nonnull EntityTreeData entityTreeData, @Nonnull WidgetList content) {
        this._treeEntityTypes = entityTreeData.getEntityTypes();
        this._fixedItems = entityTreeData.getFixedItems();
        this._content = content;
        content.clear();
        ImmutableList initialTree = entityTreeData.getChildTree();
        if (CollectionUtil.isEmpty((Iterable)initialTree)) {
            return;
        }
        for (EntityTreeItemData data : initialTree) {
            this._rootEntityTreeItems.add(new EntityTreeItem(data));
        }
        for (EntityTreeItem e : this._rootEntityTreeItems) {
            DynamicEntityTreeItem item = new DynamicEntityTreeItem(this, null, e);
            this._rootItems.put(e, item);
            this._content.add((Widget)item);
        }
    }

    private void rebuild() {
        if (this._rootNeedsRebuild) {
            this._content.clear();
            for (EntityTreeItem e : this._rootEntityTreeItems) {
                this._content.add((Widget)this._rootItems.get(e));
            }
        }
        this._rootNeedsRebuild = false;
        for (DynamicEntityTreeItem item : this._itemsToRebuild) {
            item.buildChildItem();
        }
        this._itemsToRebuild.clear();
    }

    private void addTreeIfNotExists(DynamicEntityTreeItem parentItem, EntityTreeItem entityTreeItem) {
        DynamicEntityTreeItem item;
        if (parentItem == null) {
            item = (DynamicEntityTreeItem)this._rootItems.get(entityTreeItem);
            if (item == null) {
                this._rootNeedsRebuild = true;
                this._rootEntityTreeItems.add(entityTreeItem);
                item = new DynamicEntityTreeItem(this, null, entityTreeItem);
                this._rootItems.put(entityTreeItem, item);
            }
        } else {
            item = (DynamicEntityTreeItem)parentItem.getChildItems().get(entityTreeItem);
            if (item == null) {
                this._itemsToRebuild.add(parentItem);
                parentItem._treeItem.addChild(entityTreeItem);
                item = (DynamicEntityTreeItem)parentItem.getChildItems().get(entityTreeItem);
            }
        }
        assert (item != null);
        for (EntityTreeItem child : entityTreeItem.getChildren()) {
            this.addTreeIfNotExists(item, child);
        }
    }

    public void selectEntityId(@Nullable EntityId id) {
        if (this._currentSelectedEntityId != null) {
            this.deselectEntityId(this._currentSelectedEntityId);
        }
        this._currentSelectedEntityId = id;
        if (id != null) {
            List list = this._itemsByEntityId.get((Object)id);
            if (!CollectionUtil.isEmpty((Iterable)list)) {
                this.selectItem(list);
            } else {
                EntityMediator.getInstance().getEntityTreeWithParentNodeByEntityId(id, this._treeEntityTypes, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    private void selectItem(List<DynamicEntityTreeItem> items) {
        for (DynamicEntityTreeItem item : items) {
            item.setVisible(true);
            for (DynamicEntityTreeItem parent = item.getParentItem(); parent != null; parent = parent.getParentItem()) {
                parent.setVisible(true);
                parent.updateOpenCloseIconVisibility();
            }
        }
    }

    private void deselectEntityId(EntityId id) {
        List list = this._itemsByEntityId.get((Object)id);
        if (list != null) {
            for (DynamicEntityTreeItem i : list) {
                boolean partOfFixedTree = i.isPartOfFixedTree();
                i.setVisible(partOfFixedTree);
                DynamicEntityTreeItem parent = i._parentItem;
                if (!partOfFixedTree && parent != null) {
                    --parent._expandedChildItemCount;
                }
                while (parent != null) {
                    parent.updateOpenCloseIconVisibility();
                    parent = parent._parentItem;
                }
            }
        }
    }
}

