/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.design.server;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.design.business.ThemeService;
import de.justsoftware.onx.design.client.model.FrontendTheme;
import de.justsoftware.onx.design.shared.ThemeController;
import de.justsoftware.onx.design.shared.model.ITheme;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.design.shared.model.WebResource;
import de.justsoftware.web.design.WebResourceHandler;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gwtwidgets.server.spring.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThemeControllerImpl
implements ThemeController {
    @Autowired
    private ThemeService _legacyThemeService;
    @Autowired
    private de.justsoftware.onx.tenantdesign.ThemeService _themeService;
    @Autowired
    private SessionAuthorizationContextProvider _authContextProvider;
    @Autowired
    private WebResourceHandler _webResourceHandler;
    @Autowired
    private ConfigService _configService;

    public FrontendTheme getDefaultTheme() {
        return FrontendTheme.copyOf((ITheme)this._themeService.getLegacyTheme(null));
    }

    public FrontendTheme updateDefaultTheme(FrontendTheme newTheme) throws ServiceException {
        return FrontendTheme.copyOf((ITheme)this._legacyThemeService.updateDefaultTheme((ITheme)newTheme, (AuthorizationCheckContext)this._authContextProvider.getAuthorizationContextForCurrentUser()));
    }

    @CheckForNull
    private FrontendTheme toFrontendTheme(@Nullable Theme theme) {
        return theme != null ? FrontendTheme.copyOf((ITheme)theme) : null;
    }

    public ImmutableMap<WebResource, String> getCurrentResourceUris(Set<WebResource> resources) {
        HttpServletRequest request = ServletUtils.getRequest();
        HttpServletResponse response = ServletUtils.getResponse();
        if (request == null || response == null) {
            return ImmutableMap.of();
        }
        return this._webResourceHandler.getCurrentResourceNames(resources, request, response);
    }

    public ImmutableSet<ThemeAttributeType> getEditableThemeAttributes() {
        return (ImmutableSet)this._configService.getEditableThemeAttributes().stream().filter(it -> !it.getScope().equals((Object)ThemeAttributeType.Scope.ENTITY_THEME)).filter(it -> !it.getVariableName().equals(ThemeAttributeType.HORIZONTAL_NAVIGATION_NOTIFICATION_COUNT_COLOR.getVariableName())).collect(ImmutableSet.toImmutableSet());
    }

    public FrontendTheme getFactoryDefaultTheme() throws ServiceException {
        return FrontendTheme.copyOf((ITheme)this._legacyThemeService.getFactoryDefaultTheme());
    }
}

