/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui.recommendastask;

import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.github.gwtbootstrap.client.ui.constants.IconSize;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.WaitSpinner;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.container.presentation.client.ui.recommendastask.EditablePager;
import de.justsoftware.onx.container.presentation.client.ui.recommendastask.RecommendEntityAsTaskView;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class SimpleEditablePager<T>
implements IsWidget,
RecommendEntityAsTaskView.RemoveHandler<T>,
EditablePager {
    private static final int PAGE_SIZE = 10;
    private final FlowPanel _pagerContainer = new FlowPanel();
    private final FlowPanel _pagerContent = new FlowPanel();
    private final FlowPanel _navContent = new FlowPanel();
    private final IconAnchor _navPrev = new IconAnchor();
    private final IconAnchor _navNext = new IconAnchor();
    private final FlowPanel _progressIndicator = new FlowPanel();
    private final WaitSpinner _spinner = new WaitSpinner(IconSize.TWO_TIMES);
    private final EditablePager.PagerDataProvider<T> _dataProvider;
    private final BasicConstants _i18n;
    private int _offset = 0;

    SimpleEditablePager(EditablePager.PagerDataProvider<T> dataProvider, BasicConstants i18n) {
        this._dataProvider = dataProvider;
        this._i18n = i18n;
        this._pagerContainer.addStyleName("pager");
        this._pagerContainer.setStyleName("hidden", true);
        this._pagerContainer.add((Widget)this._pagerContent);
        this._progressIndicator.add((Widget)this._spinner);
        this._progressIndicator.addStyleName("progress-indicator");
        this._progressIndicator.setVisible(false);
        this._pagerContainer.add((Widget)this._progressIndicator);
        this._navContent.add((Widget)this._navPrev);
        this._navContent.add((Widget)this._navNext);
        this._navPrev.setIcon(IconType.CHEVRON_LEFT);
        this._navNext.setIcon(IconType.CHEVRON_RIGHT);
        this._navContent.addStyleName("nav");
        this._pagerContainer.add((Widget)this._navContent);
        this._navNext.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._navPrev.setStyleName("invisible", true);
        this._navNext.setStyleName("invisible", true);
        this._navPrev.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void fetchPrevious() {
        if (this._offset <= 10) {
            return;
        }
        this._progressIndicator.setVisible(true);
        this._dataProvider.getPage(this._offset - 20, 10, (EditablePager.PagerDataProviderCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setPageData(ListAndCount<T> data) {
        this._pagerContent.clear();
        for (Object item : data) {
            this.addRemoveableLabel(item);
        }
        this._progressIndicator.setVisible(false);
    }

    private void fetchNext() {
        this._progressIndicator.setVisible(true);
        this._dataProvider.getPage(this._offset, 10, (EditablePager.PagerDataProviderCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setElementVisibility(ListAndCount<T> data, boolean navNextInvisible, boolean navPrevInvisible) {
        this._navNext.setStyleName("invisible", navNextInvisible);
        this._navPrev.setStyleName("invisible", navPrevInvisible);
        if (navNextInvisible && navPrevInvisible) {
            if (data.size() == 0) {
                this._pagerContainer.setStyleName("hidden", true);
            } else {
                this._pagerContainer.setStyleName("hidden", false);
                this._navContent.setVisible(false);
            }
        } else {
            this._pagerContainer.setStyleName("hidden", false);
            this._navContent.setVisible(true);
        }
    }

    private void addRemoveableLabel(T item) {
        FlowPanel container = new FlowPanel();
        container.addStyleName("removeable-label");
        container.add(this._dataProvider.createLabel(item));
        Anchor removeLink = new Anchor(this._i18n.remove());
        removeLink.addStyleName("remove-link");
        removeLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        container.add((Widget)removeLink);
        this._pagerContent.add((Widget)container);
    }

    public Widget asWidget() {
        return this._pagerContainer;
    }

    public void onRemove(T id) {
        this._dataProvider.itemRemoved(id);
        this.refreshPage();
    }

    public void refreshPage() {
        if (this._offset >= 10) {
            this._offset -= 10;
        }
        this.fetchNext();
    }
}

