/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.HistoryManager;
import com.github.gwtbootstrap.client.ui.ButtonGroup;
import com.github.gwtbootstrap.client.ui.NavHeader;
import com.google.common.collect.ImmutableMap;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.user.client.ui.JucoDropdownButton;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JCModalBox;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.container.presentation.client.presenter.EditEntityLinkCreator;
import de.justsoftware.onx.container.presentation.client.presenter.EntityCreateBaseDataPresenter;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreateOrEditSubmitButtonsHandler;
import de.justsoftware.onx.container.presentation.client.ui.EntityCreatePopupHandler;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditHandler;
import de.justsoftware.onx.container.presentation.client.ui.EntityEditView;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.i18n.EntityMessages;
import de.justsoftware.onx.container.shared.model.EditEntityHistoryTokenTabName;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityCreatePopup
implements EntityCreateOrEditSubmitButtonsHandler,
EntityCreatePopupHandler,
EntityEditView {
    private final EntityType _entityType;
    private final String _trackingContext;
    private final JCModalBox _modalBox;
    private final JCButton _finishButton;
    private final ButtonGroup _submitButtons = new ButtonGroup();
    private final JucoDropdownButton _continueButton = new JucoDropdownButton();
    private final EntityConstants _entityConstants;
    private final ClientFactory _clientFactory;

    public EntityCreatePopup(ClientFactory clientFactory, EntityType entityType, String trackingContext) {
        this._entityType = entityType;
        this._trackingContext = trackingContext;
        this._clientFactory = clientFactory;
        this._entityConstants = this._clientFactory.entityFactory().entityConstants(this._entityType);
        EntityMessages entityMessages = this._clientFactory.entityFactory().entityMessages(this._entityType);
        BasicConstants basicConstants = this._clientFactory.localizedMessages().basicConstants();
        String title = entityMessages.createEntityOfType(this._entityType.name());
        this._modalBox = new JCModalBox(title);
        this._modalBox.getContent().addStyleName("entity-create-popup");
        String cancelLabel = this._entityConstants.cancel();
        this._modalBox.addCancelLink(cancelLabel);
        String finishLabel = basicConstants.create();
        this._finishButton = new JCButton(finishLabel);
        this._continueButton.setDropup(true);
        this._continueButton.add((Widget)new NavHeader(this._entityConstants.finishAndContinueTo()));
        this._submitButtons.add((Widget)this._finishButton);
        this.setSubmitButtonsEnabled(false);
        this._modalBox.getFooter().add((Widget)this._submitButtons);
    }

    public static void show(ClientFactory clientFactory, EntityType entityType, @Nullable Date defaultDate, String trackingContext) {
        new EntityCreateBaseDataPresenter(entityType, clientFactory, defaultDate, new EntityCreatePopup(clientFactory, entityType, trackingContext), (entityId, nextTab) -> {
            String token = nextTab != null ? EntityEditHandler.token((HistoryManager)clientFactory.historyManager(), (EntityId)entityId, (CoreApp)CoreApp.SOCIAL, (EditEntityHistoryTokenTabName)nextTab) : EntityOverviewHandler.token((EntityId)entityId);
            History.newItem((String)token);
        }, s -> {}).show();
    }

    @Nonnull
    public String getSourceForTracking() {
        return this._trackingContext;
    }

    public void hide() {
        this._modalBox.hide();
    }

    public void setWaitIconVisibility(boolean visible) {
        this._modalBox.showProgressIndicator(visible);
    }

    public void setSubmitButtonsEnabled(boolean enabled) {
        this._finishButton.setEnabled(enabled);
        this._continueButton.setEnabled(enabled);
    }

    public void reCenter() {
        this._modalBox.show();
    }

    public void addSaveAndContinueButton(ImmutableMap<EditEntityHistoryTokenTabName, ClickHandler> visibleTabs) {
        this._submitButtons.add((Widget)this._continueButton);
        visibleTabs.forEach((tab, clickHandler) -> this._continueButton.add((Widget)EditEntityLinkCreator.createLink((EditEntityHistoryTokenTabName)tab, (ClickHandler)clickHandler, (EntityConstants)this._entityConstants)));
    }

    public void addFinishButtonClickHandler(ClickHandler handler) {
        this._finishButton.addClickHandler(handler);
    }

    public AcceptsOneWidget getContentPanel() {
        SimplePanel panel = new SimplePanel();
        this._modalBox.getContent().add((Widget)panel);
        return panel;
    }

    public void addCloseHandler(JCModalBox.CloseHandler closeHandler) {
        this._modalBox.addCloseHandler(closeHandler);
    }
}

