/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.presenter.recommendastask;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.presentation.client.ui.recommendastask.EditablePager;
import de.justsoftware.onx.container.presentation.client.ui.recommendastask.RecommendEntityAsTaskView;
import de.justsoftware.onx.container.presentation.shared.model.EntityRecommendationPersonModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class PersonFetchCallback
implements AsyncCallback<ImmutableMap<PersonId, EntityRecommendationPersonModel>> {
    private final RecommendEntityAsTaskView _view;
    private final Map<PersonId, EntityRecommendationPersonModel> _modelsFromCache;
    private final ImmutableList<PersonId> _receivers;
    private final Map<PersonId, EntityRecommendationPersonModel> _receiverModelCache;
    private final EditablePager.PagerDataProviderCallback<EntityRecommendationPersonModel> _pagerCallback;

    PersonFetchCallback(Map<PersonId, EntityRecommendationPersonModel> modelsFromCache, EditablePager.PagerDataProviderCallback<EntityRecommendationPersonModel> pagerCallback, RecommendEntityAsTaskView view, Map<PersonId, EntityRecommendationPersonModel> receiverModels, ImmutableList<PersonId> receivers) {
        this._modelsFromCache = modelsFromCache;
        this._pagerCallback = pagerCallback;
        this._view = view;
        this._receiverModelCache = receiverModels;
        this._receivers = receivers;
    }

    public void onFailure(Throwable caught) {
        this._view.error(caught.getMessage());
    }

    public void onSuccess(ImmutableMap<PersonId, EntityRecommendationPersonModel> result) {
        this._receiverModelCache.putAll(result);
        HashMap<PersonId, EntityRecommendationPersonModel> pageData = new HashMap<PersonId, EntityRecommendationPersonModel>();
        pageData.putAll((Map<PersonId, EntityRecommendationPersonModel>)result);
        pageData.putAll(this._modelsFromCache);
        ImmutableList pagerData = ImmutableList.copyOf(pageData.values());
        this._pagerCallback.onData(new ListAndCount(this._receivers.size(), (Collection)pagerData));
    }
}

