/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.ui.ConfirmPopup;
import com.freiheit.toro.client.ui.MessagePopup;
import com.freiheit.toro.util.client.LoggingUtil;
import com.freiheit.toro.util.client.WidgetUtil;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.user.client.ui.CopyToClipboardIcon;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.model.JsPromise;
import de.justsoftware.onx.common.presentation.client.model.Promise;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.container.presentation.client.EntityUtils;
import de.justsoftware.onx.container.presentation.client.GwtToJsEntityApi;
import de.justsoftware.onx.container.presentation.client.ui.WriteMessageToEntityMembersWidget;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.DeleteEntityReferenceException;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionReviewData;
import de.justsoftware.onx.person.presentation.client.ui.ReviewsView;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class GwtToJsEntityApi
extends JavaScriptObject {
    public static final GwtToJsEntityApi INSTANCE = GwtToJsEntityApi.create();
    private static final ClientFactory CLIENT_FACTORY = ClientFactoryImpl.INSTANCE;

    protected GwtToJsEntityApi() {
    }

    @CheckForNull
    private static Action parseEntityOptionsAction(String action) {
        Optional staticEntityAction = Enums.getIfPresent(StaticEntityAction.class, (String)action);
        if (staticEntityAction.isPresent()) {
            return (Action)staticEntityAction.get();
        }
        Optional staticAction = Enums.getIfPresent(StaticAction.class, (String)action);
        if (staticAction.isPresent()) {
            return (Action)staticAction.get();
        }
        return null;
    }

    @CheckForNull
    public static String getVersionCompareHistoryToken(String entityId) {
        EntityId id = EntityId.parse((String)entityId);
        if (id == null) {
            LoggingUtil.error((Object)"GwtToJsEntityApi", (String)"EntityId not defined or invalid.");
            return null;
        }
        return CLIENT_FACTORY.historyManager().createHistoryItem(HistoryToken.ENTITY_VERSION_COMPARE, new Object[]{id});
    }

    @Nonnull
    private static AsyncCallback<EntityVersionClientModel> getStartReleasePopupCallback(EntityVersionId entityVersionId, EntityVersionReviewData reviewData, ReviewsView.PopupClosedCallback closeHandler) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nonnull
    private static AsyncCallback<EntityVersionReviewData> getNextReviewStepCallback(EntityVersionId entityVersionId, ReviewsView.PopupClosedCallback closeHandler) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static void handleEntityVersionAction(String entityVersionIdString) {
        EntityVersionId entityVersionId = EntityVersionId.parse((String)entityVersionIdString);
        ReviewsView.PopupClosedCallback closeHandler = success -> CLIENT_FACTORY.historyManager().refreshCurrentToken();
        if (entityVersionId != null) {
            CLIENT_FACTORY.entityVersionFactory().controller().getVersionReviewData(entityVersionId, GwtToJsEntityApi.getNextReviewStepCallback((EntityVersionId)entityVersionId, (ReviewsView.PopupClosedCallback)closeHandler));
        } else {
            closeHandler.onClose(false);
        }
    }

    public static void handleEntityOptionAction(String entityId, String action) {
        EntityId id = EntityId.parse((String)entityId);
        if (id == null) {
            LoggingUtil.error((Object)"GwtToJsEntityApi", (String)"EntityId not defined or invalid.");
            return;
        }
        Action parsedAction = GwtToJsEntityApi.parseEntityOptionsAction((String)action);
        if (parsedAction == null) {
            LoggingUtil.error((Object)"GwtToJsEntityApi", (String)("Action '" + action + "' unknown."));
            return;
        }
        CLIENT_FACTORY.entityFactory().mediator().getDetailsById(id).then(entity -> {
            GwtToJsEntityApi.handleAction((EntityDetails)entity, (Action)parsedAction);
            return entity;
        }, Promise.DEFAULT_ERROR_HANDLER);
    }

    private static void showDeleteEntityConfirmPopup(EntityDetails entity) {
        EntityConstants entityConstants = CLIENT_FACTORY.entityFactory().entityConstants(entity.getType());
        ConfirmPopup.makeConfirmPopup((String)entityConstants.realyWantToDeleteEntity(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */).show();
    }

    private static boolean handleDeleteEntityError(EntityConstants entityConstants, Throwable cause) {
        if (cause instanceof DeleteEntityReferenceException) {
            MessagePopup popup = WidgetUtil.getFakeSingletonMessageBox();
            DeleteEntityReferenceException refEx = (DeleteEntityReferenceException)cause;
            FlowPanel panel = new FlowPanel();
            panel.add((Widget)new Label(entityConstants.deleteNotPossibleAssigmentAvailable()));
            panel.add((Widget)EntityUtils.createEntityNameLinksOrLabels((Iterable)refEx.getReferences(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */));
            if (popup != null) {
                popup.setType(1);
                popup.setMessage((Widget)panel);
                popup.show();
            }
            return true;
        }
        return false;
    }

    private static boolean handleAction(EntityDetails entity, Action action) {
        if (action instanceof StaticEntityAction) {
            return GwtToJsEntityApi.handleStaticEntityAction((EntityDetails)entity, (StaticEntityAction)((StaticEntityAction)action));
        }
        return false;
    }

    private static boolean handleStaticEntityAction(EntityDetails entity, StaticEntityAction action) {
        switch (7.$SwitchMap$de$justsoftware$onx$common$shared$model$action$StaticEntityAction[action.ordinal()]) {
            case 1: {
                CLIENT_FACTORY.entityRecommendationClientFactory().createEntityRecommendationAsTaskPresenter((EntityInfo)entity).show();
                return true;
            }
            case 2: {
                CLIENT_FACTORY.entityRecommendationClientFactory().createEntityRecommendationPresenter((EntityInfo)entity).show(ImmutableSet.of());
                return true;
            }
            case 3: {
                new WriteMessageToEntityMembersWidget((EntityInfo)entity).show();
                return true;
            }
            case 4: {
                GwtToJsEntityApi.showDeleteEntityConfirmPopup((EntityDetails)entity);
                return true;
            }
            case 5: {
                EntityVersionClientModel entityVersion = entity.getVersion();
                if (entityVersion == null) {
                    return false;
                }
                CLIENT_FACTORY.entityVersionFactory().controller().archiveVersion(entity.getId(), entityVersion.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static JsPromise<String, String> getSendFeedbackUrl(String entityId) {
        return JsPromise.create((resolve, reject) -> {
            EntityId id = EntityId.parse((String)entityId);
            if (id == null) {
                reject.call((Object)"EntityId not defined or invalid.");
                return;
            }
            CLIENT_FACTORY.entityMemberClientFactory().clientService().getEmailModelForFeedbackEmailToAdmins(id, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        });
    }

    public static void handleCopyAddress() {
        new CopyToClipboardIcon(CopyToClipboardIcon.COPY_ADDRESS_TEXT_PROVIDER, I18nMediator.BASIC_CONSTANTS.copyAddressToClipboard(), I18nMediator.BASIC_CONSTANTS.currentPageAddress()).handleCopyToClipboard();
    }

    public final native void init();

    @Nonnull
    private static GwtToJsEntityApi create() {
        GwtToJsEntityApi result = (GwtToJsEntityApi)JavaScriptObject.createObject().cast();
        result.init();
        return result;
    }
}

