/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.components;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.i18n.DateAndTimeConstants;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.freiheit.toro.util.client.LoggingUtil;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.TextArea;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.Dictionary;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.EntityReleaseAuthorSelectionView;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JCDialogBox;
import de.justsoftware.onx.common.presentation.client.ui.TimestampBox;
import de.justsoftware.onx.common.presentation.client.ui.components.EntityReleaseProcessPopup;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.i18n.EntityVersionConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseClientModel;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseDataOption;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import de.justsoftware.onx.person.presentation.client.ui.ReviewsView;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolation;
import de.justsoftware.onx.validation.shared.model.JucoValidationPath;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityReleaseProcessPopup
extends JCDialogBox
implements Window.ScrollHandler,
ResizeHandler {
    private static final String CONTROL_GROUP_CLASS = "control-group";
    private static final String ERROR_CLASS = "error";
    private static final EntityReleaseProcessPopupUiBinder BINDER = (EntityReleaseProcessPopupUiBinder)GWT.create(EntityReleaseProcessPopupUiBinder.class);
    @UiField
    SimplePanel _author;
    @UiField
    FlowPanel _versionDependentPanel;
    @UiField
    FlowPanel _reviewerControlsPanel;
    @UiField
    JCButton _submitButton;
    @UiField
    ControlGroup _expirationDateControlGroup;
    @UiField
    TimestampBox _expirationDate;
    @UiField
    HelpInline _expirationDateHelp;
    @UiField
    FlowPanel _expirationDatePreselect;
    @UiField
    ControlGroup _versionReleaseDateControlGroup;
    @UiField
    SimplePanel _releaseDate;
    @UiField
    HelpInline _releaseDateHelp;
    @UiField
    ControlGroup _versionSelectionControlGroup;
    @UiField
    ListBox _versionSelection;
    @UiField
    HelpInline _versionSelectionHelp;
    @UiField
    ControlGroup _changeMessageControlGroup;
    @UiField
    TextArea _changeMessage;
    @UiField
    HelpInline _changeMessageHelp;
    @UiField
    ControlGroup _commentForReviewersControlGroup;
    @UiField
    HelpInline _commentForReviewerHelp;
    @UiField
    TextArea _commentForReviewer;
    private final EntityVersionClientModel _version;
    private final EntityVersionConstants _versionMessages;
    private final DateAndTimeConstants _dateAndTimeMessages;
    private final ReviewerSelectWidget _reviewerSelectWidget;
    private final ClientEntityConfig _entityConfig;
    private final HandlerRegistration _scrollHandlerRegistration;
    private final HandlerRegistration _resizeHandlerRegistration;
    private final ClientFactory _clientFactory;
    private final EntityReleaseAuthorSelectionView.EntityReleaseAuthorSelectionPresenter _authorSelectionPresenter;
    private final ReleaseDateComponent _releaseDateComponent;
    private final ReviewsView.PopupClosedCallback _closeCallback;
    private final boolean _mayReviewFirstStage;

    public EntityReleaseProcessPopup(@Nonnull EntityVersionClientModel version, @Nonnull EntityType entityType, @Nullable TimeZone timeZone, @Nullable DateWithoutTimezone expirationDateLastPublishedVersion, boolean mayReview, int maxDaysAsActiveVersion, @Nonnull ClientFactory clientFactory, @Nullable ReviewsView.PopupClosedCallback closeCallback) {
        super(false);
        this._clientFactory = clientFactory;
        this._version = version;
        this._versionMessages = I18nMediator.LOCALIZED_MESSAGES.entityVersionConstants();
        this._dateAndTimeMessages = I18nMediator.LOCALIZED_MESSAGES.dateAndTimeConstants();
        this._mayReviewFirstStage = mayReview;
        this.setContent((IsWidget)BINDER.createAndBindUi((Object)this));
        this.addContentStyle("release-process-popup");
        this.setText(this._versionMessages.release());
        this._entityConfig = HostPropertiesMediator.getClientEntityConfig((EntityType)entityType);
        this._authorSelectionPresenter = this.initAuthorSelector(this._author, version.getEntityId(), this._entityConfig, version.getAuthorId());
        this.initVersionSelector();
        this.handleVersionSelect(null);
        this._reviewerSelectWidget = new ReviewerSelectWidget(this);
        this._reviewerControlsPanel.add((Widget)this._reviewerSelectWidget);
        this._releaseDateComponent = this.initReleaseDateComponent(timeZone);
        this.initExpirationDate(expirationDateLastPublishedVersion, maxDaysAsActiveVersion);
        this.initTextFields();
        this._scrollHandlerRegistration = Window.addWindowScrollHandler((Window.ScrollHandler)this);
        this._resizeHandlerRegistration = Window.addResizeHandler((ResizeHandler)this);
        this._closeCallback = closeCallback;
    }

    private void initTextFields() {
        this._changeMessageControlGroup.setVisible(this._entityConfig.getReleaseChangeMessageVisibility().isVisibleOption());
        this._commentForReviewersControlGroup.setVisible(this._entityConfig.getReleaseCommentForReviewerVisibility().isVisibleOption());
    }

    @CheckForNull
    private ReleaseDateComponent initReleaseDateComponent(@Nullable TimeZone timeZone) {
        if (this._entityConfig.getReleaseActivationDateVisibility() == EntityVersionReleaseDataOption.NOT_VISIBLE) {
            this._versionReleaseDateControlGroup.setVisible(false);
            return null;
        }
        ReleaseDateComponent result = new ReleaseDateComponent(this, this._releaseDateHelp);
        this._releaseDate.setWidget(result.getView());
        Date date = new Date();
        if (timeZone != null) {
            date = Dates.getDateWithTimezone((Date)date, (TimeZone)timeZone);
        }
        result.setDate(date);
        return result;
    }

    @Nonnull
    private EntityReleaseAuthorSelectionView.EntityReleaseAuthorSelectionPresenter initAuthorSelector(@Nonnull SimplePanel panel, @Nonnull EntityId entityId, @Nonnull ClientEntityConfig entityConfig, @Nonnull PersonId authorId) {
        EntityReleaseAuthorSelectionView.EntityReleaseAuthorSelectionPresenter presenter = this._clientFactory.entityVersionFactory().entityReleaseAuthorSelectionPresenter(entityConfig, entityId, authorId);
        panel.setWidget((IsWidget)presenter.getView());
        return presenter;
    }

    private void initExpirationDate(@Nullable DateWithoutTimezone expirationDateLastPublishedVersion, int maxDaysAsActiveVersion) {
        if (this._entityConfig.getReleaseExpirationDateVisibility() == EntityVersionReleaseDataOption.NOT_VISIBLE) {
            this._expirationDateControlGroup.setVisible(false);
            return;
        }
        if (expirationDateLastPublishedVersion != null) {
            this._expirationDate.setValue((Object)expirationDateLastPublishedVersion);
        }
        this._expirationDate.getDateBox().addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        DateWithoutTimezone currentReleaseDate = this._releaseDateComponent.getDate();
        this._expirationDatePreselect.add((Widget)new InlineLabel(this._versionMessages.expirationDateQuickSelectLabel()));
        FluentIterable.from((Object[])ExpirationDateLapseOfTime.values()).filter(expirationDateLapseOfTime -> Dates.differenceInDays((Date)expirationDateLapseOfTime.getExpirationDate((Date)currentReleaseDate), (Date)currentReleaseDate) <= maxDaysAsActiveVersion).forEach(option -> this.addExpirationDateLapseOfTime(option));
    }

    private void addExpirationDateLapseOfTime(@Nonnull ExpirationDateLapseOfTime expirationDateOption) {
        if (this._expirationDatePreselect.getWidgetCount() > 1) {
            this._expirationDatePreselect.add((Widget)new InlineLabel(", "));
        }
        Anchor anchor = new Anchor(expirationDateOption.getLabel(this._dateAndTimeMessages));
        anchor.addClickHandler(event -> this._expirationDate.setValue((Object)expirationDateOption.getExpirationDate((Date)this._releaseDateComponent.getDate())));
        this._expirationDatePreselect.add((Widget)anchor);
    }

    private void markHelpboxAsInError(@Nonnull HelpInline helpbox, @Nonnull String errorMessage) {
        this.addClassToMatchingParent((Element)helpbox.getElement(), "error", "control-group");
        helpbox.setText(errorMessage);
    }

    private void initVersionSelector() {
        if (this._entityConfig.getReleaseVersionTypeVisibility() == EntityVersionReleaseDataOption.NOT_VISIBLE) {
            this._versionSelectionControlGroup.setVisible(false);
            return;
        }
        this._versionSelection.addItem(this._versionMessages.majorVersion(), EntityVersionType.MAJOR.name());
        if (this._version.getMajorVersion() > 0) {
            this._versionSelection.addItem(this._versionMessages.minorVerson(), EntityVersionType.MINOR.name());
        }
        this._versionSelection.setSelectedIndex(0);
    }

    @Nonnull
    private EntityVersionType getSelectedVersionType() {
        if (this._entityConfig.getReleaseVersionTypeVisibility() == EntityVersionReleaseDataOption.NOT_VISIBLE) {
            return EntityVersionType.MAJOR;
        }
        try {
            return EntityVersionType.valueOf((String)this._versionSelection.getValue());
        }
        catch (IllegalArgumentException e) {
            return EntityVersionType.MAJOR;
        }
    }

    @UiHandler(value={"_versionSelection"})
    public void handleVersionSelect(@Nullable ChangeEvent event) {
        boolean reviewMandatory;
        EntityVersionType versionType = this.getSelectedVersionType();
        switch (3.$SwitchMap$de$justsoftware$onx$container$shared$model$EntityVersionType[versionType.ordinal()]) {
            case 1: {
                reviewMandatory = this._entityConfig.areReviewersMandatoryForRelease();
                break;
            }
            default: {
                reviewMandatory = false;
            }
        }
        if (reviewMandatory) {
            this._submitButton.setText(this._versionMessages.requestRelease());
        } else {
            this._submitButton.setText(this._versionMessages.performRelease());
        }
        this._versionDependentPanel.setVisible(reviewMandatory);
    }

    @CheckForNull
    private String getOptionalTextFieldInput(@Nonnull TextArea textArea, @Nonnull EntityVersionReleaseDataOption option) {
        return option.isVisibleOption() && !StringUtil.isBlank((String)textArea.getText()) ? textArea.getText() : null;
    }

    @UiHandler(value={"_submitButton"})
    public void submit(@Nullable ClickEvent event) {
        this.clearAllMessages();
        EntityVersionType versionType = this.getSelectedVersionType();
        String changeMessage = this.getOptionalTextFieldInput(this._changeMessage, this._entityConfig.getReleaseChangeMessageVisibility());
        String commentForReviewer = this.getOptionalTextFieldInput(this._commentForReviewer, this._entityConfig.getReleaseCommentForReviewerVisibility());
        EntityVersionReleaseClientModel releaseData = new EntityVersionReleaseClientModel(this._authorSelectionPresenter.getSelected(), this._version.getId(), versionType, (List)Lists.newArrayList(), changeMessage, commentForReviewer);
        if (this.isReleaseDateRequired(this._releaseDateComponent)) {
            releaseData.setReleaseDate(this._releaseDateComponent.getDate());
        } else {
            releaseData.setReleaseDate(null);
        }
        if (this._entityConfig.getReleaseExpirationDateVisibility().isVisibleOption() && this._expirationDate.getValue() != null) {
            releaseData.setExpirationDate(new DateWithoutTimezone(this._expirationDate.getValue()));
        }
        releaseData.getReviewer().addAll(this._reviewerSelectWidget.getReviewers());
        this._clientFactory.entityVersionFactory().controller().startReleaseProcess(releaseData, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @UiHandler(value={"_cancelAnchor"})
    public void handleCancel(@Nonnull ClickEvent event) {
        this.closePopup();
    }

    private boolean isReleaseDateRequired(@Nullable ReleaseDateComponent releaseDateComponent) {
        return releaseDateComponent != null && releaseDateComponent.isChangeable() && this._entityConfig.getReleaseActivationDateVisibility().isVisibleOption();
    }

    private void closePopup() {
        if (this._closeCallback != null) {
            this._closeCallback.onClose(false);
        }
        this.hide(true);
        this._scrollHandlerRegistration.removeHandler();
        this._resizeHandlerRegistration.removeHandler();
    }

    private void handleValidationViolations(@Nonnull ImmutableSet<JucoConstraintViolation> violations) {
        for (JucoConstraintViolation error : violations) {
            String pathString = error.getPropertyPath().toString();
            LoggingUtil.error((Object)this, (String)(pathString + " - " + error.getMessage()));
            String errorMessage = this.resolveErrorMessage(error.getMessage());
            if (pathString.equals("releaseDate")) {
                this.markHelpboxAsInError(this._releaseDateHelp, errorMessage);
                continue;
            }
            if (pathString.equals("expirationDate")) {
                this._expirationDateHelp.setText(errorMessage);
                this.markHelpboxAsInError(this._expirationDateHelp, errorMessage);
                continue;
            }
            if (pathString.equals("changeMessage")) {
                this._changeMessageHelp.setText(errorMessage);
                this.markHelpboxAsInError(this._changeMessageHelp, errorMessage);
                continue;
            }
            if (pathString.equals("commentForReviewer")) {
                this._commentForReviewerHelp.setText(errorMessage);
                this.markHelpboxAsInError(this._commentForReviewerHelp, errorMessage);
                continue;
            }
            if (!pathString.startsWith("reviewer")) continue;
            this.handleReviewerViolations(error, errorMessage);
        }
    }

    @Nonnull
    private String resolveErrorMessage(@Nonnull String errorKey) {
        String key;
        String[] parts;
        if (errorKey.startsWith("{") && (parts = (key = errorKey.substring(1, errorKey.length() - 1)).split("\\.")).length == 2) {
            Dictionary constants = Dictionary.getDictionary((String)parts[0]);
            try {
                return constants.get(parts[1]);
            }
            catch (MissingResourceException e) {
                LoggingUtil.error((Object)this, (String)e.getMessage());
            }
        }
        return errorKey;
    }

    private void addClassToMatchingParent(@Nonnull Element child, @Nonnull String cssClass, @Nonnull String parentClass) {
        Element parent = child.getParentElement();
        do {
            if (!parent.getClassName().contains(parentClass)) continue;
            parent.addClassName(cssClass);
            return;
        } while ((parent = parent.getParentElement()) != null);
    }

    private void removeClassFromMatchingParent(@Nonnull Element child, @Nonnull String cssClass, @Nonnull String parentClass) {
        Element parent = child.getParentElement();
        do {
            if (!parent.getClassName().contains(parentClass)) continue;
            parent.removeClassName(cssClass);
            return;
        } while ((parent = parent.getParentElement()) != null);
    }

    private void handleReviewerViolations(@Nonnull JucoConstraintViolation error, @Nonnull String errorMessage) {
        JucoValidationPath path = error.getPropertyPath();
        String pathString = path.toString();
        int max = this._reviewerSelectWidget.size();
        for (int i = 0; i < max; ++i) {
            String testString = "reviewer.personId[" + i + "]";
            if (pathString.equals(testString)) {
                this._reviewerSelectWidget.addError(i, errorMessage);
                break;
            }
            LoggingUtil.info((Object)this, (String)(testString + "!=" + pathString));
        }
    }

    private void clearAllMessages() {
        this.clearHelpMessage(this._versionSelectionHelp);
        this.clearHelpMessage(this._releaseDateHelp);
        this.clearHelpMessage(this._changeMessageHelp);
        this.clearHelpMessage(this._expirationDateHelp);
        this.clearHelpMessage(this._commentForReviewerHelp);
        this.clearHelpMessage(this._releaseDateHelp);
        this._reviewerSelectWidget.reset();
    }

    private void clearHelpMessage(@Nonnull HelpInline help) {
        help.setText("");
        this.removeClassFromMatchingParent((Element)help.getElement(), "error", "control-group");
    }

    public void onResize(ResizeEvent event) {
        this.centerPopup();
    }

    private void centerPopup() {
        if (this.isShown()) {
            this.center();
        }
    }

    public void onWindowScroll(Window.ScrollEvent event) {
        this.centerPopup();
    }

    public void hide() {
        this.closePopup();
    }
}

