/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.impl.FocusImpl;
import de.justsoftware.onx.common.presentation.client.ui.SelectionList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SelectionList
extends Composite
implements HasWidgets {
    private final FlowPanel _selectionPanel;
    private final ArrayList<Selectable> _selectableItems = new ArrayList();
    private Selectable _selectedItem;
    private final Element _focusable;
    private Focusable _moveUpOutOfRangeFocusable;

    public SelectionList() {
        this._selectionPanel = new FlowPanel("ul");
        this._selectionPanel.addStyleName("selection-list");
        this._selectionPanel.sinkEvents(1021);
        this._focusable = FocusImpl.getFocusImplForPanel().createFocusable();
        this._focusable.getStyle().setProperty("fontSize", "0");
        this._focusable.getStyle().setProperty("position", "absolute");
        this._focusable.getStyle().setProperty("outline", "0px");
        DOM.setIntStyleAttribute((Element)this._focusable, (String)"zIndex", (int)-1);
        DOM.appendChild((Element)this._selectionPanel.getElement(), (Element)this._focusable);
        DOM.sinkEvents((Element)this._focusable, (int)6144);
        this.initWidget((Widget)this._selectionPanel);
    }

    public void setMoveUpOutOfRangeFocusable(@Nullable Focusable moveUpOutOfRangeFocusable) {
        this._moveUpOutOfRangeFocusable = moveUpOutOfRangeFocusable;
    }

    public void add(IsWidget widget) {
        this.add(widget.asWidget());
    }

    public void clear() {
        this._selectionPanel.clear();
        DOM.appendChild((Element)this._selectionPanel.getElement(), (Element)this._focusable);
        this._selectableItems.clear();
        this._selectedItem = null;
    }

    public void moveSelectionDown() {
        this.selectItem(this.getSelectedItemIndex() + 1);
    }

    public void moveSelectionUp() {
        int selectedItemIndex = this.getSelectedItemIndex();
        if (selectedItemIndex == -1) {
            this.selectItem(this._selectableItems.size() - 1);
        } else if (this._moveUpOutOfRangeFocusable != null && selectedItemIndex == 0) {
            this.itemOver(null, false);
            this._moveUpOutOfRangeFocusable.setFocus(true);
        } else {
            this.selectItem(selectedItemIndex - 1);
        }
    }

    public void addSelectable(Selectable selectable) {
        this.add(selectable.asWidget());
        this._selectableItems.add(selectable);
    }

    public void add(Widget w) {
        this._selectionPanel.add(w);
    }

    public Iterator<Widget> iterator() {
        return this._selectionPanel.iterator();
    }

    public boolean remove(Widget w) {
        return this._selectionPanel.remove(w);
    }

    @CheckForNull
    private Selectable getSelectedItem() {
        return this._selectedItem;
    }

    private int getSelectedItemIndex() {
        Selectable selectedItem = this.getSelectedItem();
        if (selectedItem != null) {
            return this._selectableItems.indexOf(selectedItem);
        }
        return -1;
    }

    private void selectItem(int index) {
        ArrayList items = this._selectableItems;
        if (index > -1 && index < items.size()) {
            this.itemOver((Selectable)items.get(index), true);
        }
    }

    private void itemOver(Selectable item, boolean focus) {
        this.selectItem(item);
        if (focus) {
            this._focusable.focus();
        }
    }

    private void selectItem(Selectable item) {
        if (item == this._selectedItem) {
            return;
        }
        if (this._selectedItem != null) {
            this._selectedItem.asWidget().setStyleName("selected", false);
        }
        if (item != null) {
            item.asWidget().setStyleName("selected", true);
        }
        this._selectedItem = item;
    }

    public void onBrowserEvent(Event event) {
        block0 : switch (DOM.eventGetType((Event)event)) {
            case 2048: {
                this.selectFirstItemIfNoneSelected();
                break;
            }
            case 128: {
                int keyCode = event.getKeyCode();
                switch (keyCode) {
                    case 38: {
                        this.moveSelectionUp();
                        this.eatEvent(event);
                        break block0;
                    }
                    case 40: {
                        this.moveSelectionDown();
                        this.eatEvent(event);
                        break block0;
                    }
                    case 9: {
                        if (event.getShiftKey()) {
                            this.moveSelectionUp();
                        } else {
                            this.moveSelectionDown();
                        }
                        this.eatEvent(event);
                        break block0;
                    }
                    case 13: 
                    case 32: {
                        this.doActionOnCurrentSelection();
                        this.eatEvent(event);
                        break block0;
                    }
                }
                break;
            }
        }
        super.onBrowserEvent(event);
    }

    public void doActionOnCurrentSelection() {
        this.selectFirstItemIfNoneSelected();
        this.doItemAction(this.getSelectedItem());
    }

    private void doItemAction(@Nullable Selectable item) {
        if (item != null) {
            item.onDoItemAction();
        }
    }

    private void eatEvent(Event event) {
        event.stopPropagation();
        event.preventDefault();
    }

    private void selectFirstItemIfNoneSelected() {
        block0: {
            Iterator iterator;
            if (this._selectedItem != null || !(iterator = this._selectableItems.iterator()).hasNext()) break block0;
            Selectable nextItem = (Selectable)iterator.next();
            this.selectItem(nextItem);
        }
    }

    public void focus() {
        this._focusable.focus();
    }
}

