/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.client.validator.ValidatableTextBox;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.google.gwt.event.dom.client.KeyPressHandler;
import de.justsoftware.onx.common.shared.util.Numbers;

public class NumberTextBox
extends ValidatableTextBox {
    private final Number _min;
    private final Number _max;

    public NumberTextBox(String fieldName) {
        this(fieldName, (Number)Long.MIN_VALUE, (Number)Long.MAX_VALUE);
    }

    public NumberTextBox() {
        this("");
    }

    public NumberTextBox(String fieldName, Number min, Number max) {
        super(fieldName);
        this._min = min;
        this._max = max;
        this.addKeyPressHandler((KeyPressHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void validate() throws ValidationException {
        super.validate();
        try {
            Number currentValue = this.getNumberValue();
            if (currentValue != null && (this._min.doubleValue() > currentValue.doubleValue() || this._max.doubleValue() < currentValue.doubleValue())) {
                throw new ValidationException(I18nMediator.BASIC_MESSAGES.numberRangeNotAllowed(this._fieldName, this._min, this._max));
            }
        }
        catch (NumberFormatException e) {
            throw new ValidationException(I18nMediator.BASIC_MESSAGES.notANumber(this._fieldName));
        }
    }

    public Number getNumberValue() throws NumberFormatException {
        if (ClientStringUtil.hasText((String)this.getValue())) {
            return Double.valueOf(this.getValue());
        }
        return null;
    }

    public Number getNumberValue(Number def) {
        try {
            Number result = this.getNumberValue();
            if (result != null) {
                return result;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return def;
    }

    public int getIntValue() {
        return this.getIntValue(0);
    }

    public int getIntValue(int def) {
        return Numbers.intValue((Number)this.getNumberValue(), (int)def);
    }

    public void setNumberValue(Number value) {
        this.setValue((Object)value.toString());
    }

    public void setIntValue(int value) {
        this.setValue((Object)String.valueOf(value));
    }
}

