/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.base.HasAlignment;
import com.github.gwtbootstrap.client.ui.base.Style;
import com.github.gwtbootstrap.client.ui.constants.Alignment;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.SpinningIconAnchor;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.HasLoadingStateWidget;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class JCButton
extends Button
implements HasAlignment,
HasLoadingStateWidget {
    private final Timer _loadingTimer;
    private final SpinningIconAnchor _loadingIcon;

    public JCButton() {
        this.addStyleName("app-bg-color");
        this._loadingIcon = new SpinningIconAnchor();
        this._loadingIcon.setIcon(IconType.REFRESH);
        this._loadingIcon.setSpin(true);
        this._loadingIcon.addStyleName("btn-loading-icon");
        this._loadingTimer = new /* Unavailable Anonymous Inner Class!! */;
    }

    public JCButton(@Nullable String text) {
        this();
        this.setText(text);
    }

    public JCButton(@Nullable String text, ClickHandler clickHandler) {
        this(text);
        this.addClickHandler(clickHandler);
    }

    public JCButton(@Nullable String text, @Nullable IconType iconType) {
        this(text);
        if (iconType != null) {
            this.setIconType(iconType);
        }
    }

    public JCButton(@Nullable String text, @Nullable IconType iconType, ClickHandler clickHandler) {
        this(text, iconType);
        this.addClickHandler(clickHandler);
    }

    @Nonnull
    public JCButton setIconType(IconType type) {
        this.setIcon(type);
        return this;
    }

    @Nonnull
    public JCButton setTextAndTitle(@Nullable String text) {
        this.setTitle(text);
        this.setText(text);
        return this;
    }

    public void setAlignment(Alignment alignment) {
        this.removeStyle((Style)Alignment.RIGHT);
        this.removeStyle((Style)Alignment.LEFT);
        this.addStyle((Style)alignment);
    }

    public void setLoading(boolean loading, int delayInMs) {
        this.setEnabled(!loading);
        if (loading) {
            this._loadingTimer.schedule(delayInMs);
        } else {
            this._loadingTimer.cancel();
            this.showLoading(false);
        }
    }

    public void setLoading(boolean loading) {
        this.setLoading(loading, 0);
    }

    private void showLoading(boolean loading) {
        this.setStyleName("loading", loading);
        if (loading) {
            this.add((Widget)this._loadingIcon);
        } else {
            this.remove((Widget)this._loadingIcon);
        }
    }
}

