/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.client.validator.ValidatableTextBox;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.google.gwt.event.dom.client.KeyDownHandler;
import javax.annotation.CheckForNull;

public class IntegerTextBox
extends ValidatableTextBox {
    private int _min;
    private int _max;

    public IntegerTextBox(String fieldName) {
        this(fieldName, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerTextBox() {
        this("");
    }

    public IntegerTextBox(String fieldName, int min, int max) {
        super(fieldName);
        this._min = min;
        this._max = max;
        this.addKeyDownHandler((KeyDownHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isDigit(int nativeEventCode) {
        switch (nativeEventCode) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return true;
            }
        }
        return false;
    }

    public void validate() throws ValidationException {
        super.validate();
        Integer integerValue = this.getIntegerValue();
        if (integerValue != null) {
            int currentValue = integerValue;
            if (this._min > currentValue || this._max < currentValue) {
                throw new ValidationException(I18nMediator.BASIC_MESSAGES.numberRangeNotAllowed(this._fieldName, (Number)this._min, (Number)this._max));
            }
        } else {
            throw new ValidationException(I18nMediator.BASIC_MESSAGES.notANumber(this._fieldName));
        }
    }

    @CheckForNull
    public Integer getIntegerValue() {
        try {
            if (ClientStringUtil.hasText((String)this.getValue())) {
                return Integer.valueOf(this.getValue());
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return null;
    }

    public void setIntValue(int value) {
        this.setValue((Object)String.valueOf(value));
    }

    public int getMinValue() {
        return this._min;
    }

    public void setMinValue(int min) {
        this._min = min;
    }

    public int getMaxValue() {
        return this._max;
    }

    public void setMaxValue(int max) {
        this._max = max;
    }

    static /* synthetic */ boolean access$000(IntegerTextBox x0, int x1) {
        return x0.isNavigationKey(x1);
    }
}

