/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.AbstractInPlaceEdit;
import de.justsoftware.onx.common.presentation.client.ui.GrowingTextArea;
import de.justsoftware.onx.common.shared.util.StringUtil;
import javax.annotation.Nonnull;

public abstract class AbstractInPlaceTextBox
extends AbstractInPlaceEdit<String> {
    protected final GrowingTextArea _editWidget = new GrowingTextArea();
    private final Label _showWidget;
    private String _descriptionText = "";
    private boolean _forceText = false;
    private String _forceTextErrorMessage = "";
    private String _textTooLongErrorMessage = "";
    private String _value = "";

    public AbstractInPlaceTextBox(@Nonnull Label showWidget, boolean handleEnter) {
        super((Object)"");
        this._showWidget = showWidget;
        this._editWidget.setWidth("100%");
        this._editWidget.addKeyDownHandler(this.getKeyDownHandler(handleEnter));
        this.setShowWidget((Widget)this._showWidget);
        this.setEditWidget((Widget)this._editWidget);
        this.setWaitWidget((Widget)new Label(""));
        this._showWidget.addClickHandler(this._editHandler);
    }

    public void setDescriptionText(String descriptionText) {
        this._descriptionText = descriptionText;
        this.setShowValue(this._value);
        this._editWidget.setDescriptionText(this._descriptionText);
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.setShowValue(this._value);
    }

    public void setEditWidth(String width) {
        this._editWidget.setWidth(width);
    }

    public void setEditHeight(String height) {
        this._editWidget.setHeight(height);
    }

    protected void setEditValue(String value) {
        this._editWidget.setText(value == null ? "" : value);
        this._editWidget.setFocus(true);
        this._editWidget.setCursorPos(this._editWidget.getText().length());
    }

    protected void setShowValue(String value) {
        this._value = value;
        if (StringUtil.isBlank((String)value) && this.isEditable()) {
            this._showWidget.setText(StringUtil.defaultIfBlank((String)this._descriptionText, (String)""));
            this._showWidget.addStyleName("clickable");
        } else {
            this._showWidget.setText(StringUtil.defaultIfBlank((String)value, (String)""));
            this._showWidget.removeStyleName("clickable");
        }
    }

    protected String validate(String value) {
        if (this._forceText && StringUtil.isBlank((String)value)) {
            return this._forceTextErrorMessage;
        }
        int maxLength = this._editWidget.getMaxLength();
        if (maxLength > 0 && maxLength < value.length()) {
            return this._textTooLongErrorMessage;
        }
        return null;
    }

    protected void setWaitValue(String value) {
    }

    public boolean isForceText() {
        return this._forceText;
    }

    public void setForceText(boolean forceText) {
        this._forceText = forceText;
    }

    public void setForceTextErrorMessage(String forceTextErrorMessage) {
        this._forceTextErrorMessage = forceTextErrorMessage;
    }

    public void setTextTooLongErrorMessage(String textTooLongErrorMessage) {
        this._textTooLongErrorMessage = textTooLongErrorMessage;
    }

    public void setMaxLength(int maxLength) {
        this._editWidget.setMaxLength(maxLength);
    }

    public void setViewStyle(String style) {
        this._showWidget.setStyleName(style);
    }

    public void setFocus(boolean focus) {
        this._editWidget.setFocus(focus);
    }
}

