/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.comments.presentation.server;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.comments.business.CommentsService;
import de.justsoftware.onx.comments.presentation.shared.CommentsRemoteService;
import de.justsoftware.onx.comments.shared.model.CommentId;
import de.justsoftware.onx.comments.shared.model.GenericComment;
import de.justsoftware.onx.comments.shared.model.db.DBComment;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommentsRemoteServiceImpl
implements CommentsRemoteService {
    @Autowired
    private CommentsService _commentsService;
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;

    public ListAndCount<GenericComment> addComment(String text, String customInfo, ItemId parentId, int max, boolean newestFirst) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._commentsService.addComment(text, customInfo, parentId, null, (AuthorizationCheckContextWithUserId)authorizationContext);
        return this._commentsService.getCommentsByParentId(parentId, max, newestFirst, (AuthorizationCheckContextWithLocale)authorizationContext);
    }

    public ListAndCount<GenericComment> deleteComment(CommentId id, int max, boolean newestFirst) {
        DBComment comment = (DBComment)InvalidIdServiceException.check((Object)this._commentsService.getDBCommentById(id));
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._commentsService.deleteComment(id, (AuthorizationCheckContextWithUserId)authorizationContext);
        return this._commentsService.getCommentsByParentId(comment.getParentId(), max, newestFirst, (AuthorizationCheckContextWithLocale)authorizationContext);
    }

    public ListAndCount<GenericComment> getCommentsByParentId(ItemId id, int max, boolean newestFirst) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this._commentsService.getCommentsByParentId(id, max, newestFirst, (AuthorizationCheckContextWithLocale)authorizationContext);
    }

    public Integer getCommentCount(GlobalId id) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        authorizationContext.check((ItemId)id, (Action)StaticAction.COMMENTS_READ);
        return this._commentsService.getCommentCount((ItemId)id);
    }

    public GenericComment editComment(CommentId id, String text) {
        AuthorizationContext authCtx = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._commentsService.editComment(id, text, null, (AuthorizationCheckContextWithUserId)authCtx);
        return (GenericComment)InvalidIdServiceException.check((Object)this._commentsService.getComment(id, (AuthorizationCheckContextWithLocale)authCtx));
    }
}

