/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.calendar.presentation.server.impl;

import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.calendar.business.CalendarFeedService;
import de.justsoftware.onx.calendar.presentation.shared.CalendarRemoteService;
import de.justsoftware.onx.calendar.shared.model.ICalAccessToken;
import de.justsoftware.onx.common.shared.model.PersonId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CalendarRemoteServiceImpl
implements CalendarRemoteService {
    @Autowired
    private CalendarFeedService _calendarFeedService;
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;

    public ICalAccessToken getICalAccessToken() {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this._calendarFeedService.getICalAccessToken(authorizationContext.getUserId());
    }

    public void updateCalendarSyncStatus(boolean isActive) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._calendarFeedService.updateTokenStatus(authorizationContext.getUserId(), isActive);
    }

    public ICalAccessToken resetICalLink() {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser();
        PersonId personId = authorizationContext.getUserId();
        this._calendarFeedService.invalidateICalTokenForUser(personId);
        return this._calendarFeedService.getICalAccessToken(personId);
    }
}

