/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.calendar.presentation.client.ui;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.calendar.presentation.client.CalendarViewHandler;
import de.justsoftware.onx.calendar.presentation.client.ui.CalendarViewAppointmentBadgePopupContent;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.ui.PlaceHolderPanel;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.shared.model.EntityBadge;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CalendarViewAppointmentBadgePopupContent
extends Composite {
    private static final CalendarViewAppointmentBadgePopupContentUIBinder BINDER = (CalendarViewAppointmentBadgePopupContentUIBinder)GWT.create(CalendarViewAppointmentBadgePopupContentUIBinder.class);
    @UiField
    Anchor _label;
    @UiField
    Anchor _name;
    @UiField
    FlowPanel _details;
    @UiField
    FlowPanel _footer;
    private final CalendarViewHandler _calendarViewHandler;
    private ClickHandler _displayAppointmentOverviewClickHandler = null;

    public CalendarViewAppointmentBadgePopupContent(@Nonnull EntityBadge entity, @Nullable CalendarViewHandler calendarViewHandler, int width) {
        this._calendarViewHandler = calendarViewHandler;
        this.initWidget((Widget)BINDER.createAndBindUi((Object)this));
        if (width >= 0) {
            String widthInclPadding = width + 20 + "px";
            this.setWidth(widthInclPadding);
            this._label.setWidth(width + "px");
        }
        this.addDetails(entity);
    }

    private void addDetails(@Nonnull EntityBadge badge) {
        String location;
        boolean hasLocation;
        this.initAnchor(this._name, badge.getName(), (EntityId)badge.getId());
        List linkedEntities = badge.getLinkedEntities();
        if (!CollectionUtil.isEmpty((Iterable)linkedEntities)) {
            EntityInfo firstParent = (EntityInfo)linkedEntities.get(0);
            this.initAnchor(this._label, firstParent.getName(), (EntityId)firstParent.getId());
        }
        DateWithoutTimezone startAt = badge.getStartAt();
        DateWithoutTimezone endAt = badge.getEndAt();
        if (startAt != null && endAt != null) {
            this.addEntityDetails(IconType.TIME, this.getDuration((Date)startAt, (Date)endAt, badge.getTimeZone()));
        }
        if (hasLocation = ClientStringUtil.hasText((String)(location = badge.getLocation()))) {
            this.addEntityDetails(IconType.MAP_MARKER, location);
        }
        PlaceHolderPanel memberStatusPanel = new PlaceHolderPanel();
        this._footer.add((Widget)memberStatusPanel);
        ClientFactoryImpl.INSTANCE.entityMemberClientFactory().clientService().getMyMemberStatus((EntityId)badge.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addEntityDetails(@Nonnull IconType iconType, @Nonnull String text) {
        FlowPanel detail = new FlowPanel();
        detail.addStyleName("clearfix");
        detail.add((Widget)new Icon(iconType));
        Label label = new Label(text);
        label.setTitle(text);
        detail.add((Widget)label);
        this._details.add((Widget)detail);
    }

    private void initAnchor(@Nonnull Anchor anchor, @Nonnull String name, @Nonnull EntityId id) {
        anchor.addClickHandler(this.getDisplayAppointmentOverviewClickHandler());
        anchor.setText(name);
        anchor.setTitle(name);
        anchor.setHref("#" + History.encodeHistoryToken((String)EntityOverviewHandler.token((EntityId)id)));
    }

    private String getDuration(Date startTimestamp, Date endTimestamp, @Nullable TimeZone timezone) {
        DateFormatter dateFormatter = ClientFactoryImpl.INSTANCE.dateFormatter();
        StringBuffer result = new StringBuffer();
        boolean isWholeDay = Dates.isWholeDay((Date)startTimestamp, (Date)endTimestamp);
        boolean isSameDay = Dates.areOnTheSameDay((Date)startTimestamp, (Date)endTimestamp);
        result.append(dateFormatter.formatDate(startTimestamp));
        if (!isSameDay) {
            result.append(" - ").append(dateFormatter.formatDate(endTimestamp));
        }
        if (!isWholeDay) {
            result.append(", ").append(dateFormatter.formatTime(startTimestamp)).append(" - ").append(dateFormatter.formatTime(endTimestamp));
        }
        if (timezone != null) {
            result.append(" (").append(timezone.getDisplayString()).append(")");
        }
        return result.toString();
    }

    private ClickHandler getDisplayAppointmentOverviewClickHandler() {
        if (this._displayAppointmentOverviewClickHandler == null) {
            this._displayAppointmentOverviewClickHandler = new /* Unavailable Anonymous Inner Class!! */;
        }
        return this._displayAppointmentOverviewClickHandler;
    }
}

