/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.presentation.client.ui;

import com.freiheit.toro.client.event.EventListener;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.i18n.AlbumConstants;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.freiheit.toro.util.client.WidgetUtil;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.album.presentation.client.events.ImageDeletedEvent;
import de.justsoftware.onx.album.presentation.client.ui.AlbumsComponentWidget;
import de.justsoftware.onx.album.presentation.client.ui.AlbumsOverviewHandler;
import de.justsoftware.onx.album.presentation.client.ui.ImageOverviewHandler;
import de.justsoftware.onx.album.shared.model.AlbumImage;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.album.shared.model.Albums;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.InfoBoxWidget;
import de.justsoftware.onx.common.presentation.client.ui.JucoIconTypes;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.components.presentation.client.ui.AnchorPanel;
import de.justsoftware.onx.container.shared.model.GlobalId;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;

public final class AlbumsComponentWidget
extends InfoBoxWidget {
    private static final AlbumConstants ALBUM = I18nMediator.ALBUM;
    private static final BasicConstants BASIC = I18nMediator.BASIC_CONSTANTS;
    private static AlbumsComponentWidget _instance = null;
    private static final AlbumsComponentWidgetContentUIBinder CONTENT_UI_BINDER = (AlbumsComponentWidgetContentUIBinder)GWT.create(AlbumsComponentWidgetContentUIBinder.class);
    private final AlbumsComponentWidgetContent _content = new AlbumsComponentWidgetContent();
    private GlobalId _parentId = null;
    private final EventManager.EventManagerHelper _eventManagerHelper;
    private final ClickHandler _newAlbumClickHandler = new /* Unavailable Anonymous Inner Class!! */;

    private AlbumsComponentWidget(@Nonnull EventManager eventManager) {
        this._eventManagerHelper = new EventManager.EventManagerHelper(eventManager);
        this.setContent((Widget)this._content);
        this.setLabel(ALBUM.images());
    }

    @Nonnull
    public static AlbumsComponentWidget getInstance(@Nonnull Albums albums, @Nonnull EventManager eventManager) {
        if (_instance == null) {
            _instance = new AlbumsComponentWidget(eventManager);
        }
        _instance.setAlbums(albums);
        return _instance;
    }

    public void setAlbums(@Nonnull Albums albums) {
        this._parentId = albums.getParentId();
        this.setLabel((Widget)AlbumsOverviewHandler.linkToAlbums((String)ALBUM.images(), (GlobalId)this._parentId));
        ArrayList<Widget> images = new ArrayList<Widget>();
        for (AlbumImage i : albums.getRandomImages()) {
            images.add(this.createImage(i));
        }
        this._content._imageLoop.setWidgets(images);
        this.clearActions();
        Set may = albums.getMay();
        boolean mayAdd = may.contains(StaticAction.ALBUM_CREATE);
        if (mayAdd && may.contains(StaticAction.ALBUM_SHOW_ACTIONS)) {
            this.addActionIcon(JucoIconTypes.ADD, this._newAlbumClickHandler, BASIC.add());
        }
        this._content._noElementsPanel.clear();
        if (images.isEmpty()) {
            this._content._noElementsPanel.add((Widget)(mayAdd ? WidgetUtil.insertNoHistoryHyperlink((String)ALBUM.noImagesUploadedYetAddOne(), (ClickHandler)this._newAlbumClickHandler) : new Label(ALBUM.noImagesUploadedYet())));
        }
    }

    @Nonnull
    private Widget createImage(@Nonnull AlbumImage i) {
        AnchorPanel result = new AnchorPanel();
        result.add((Widget)new Image(ImageUrlUtil.getFullAlbumImageUrl((ImageSize)ImageSize.SMALL, (String)i.getFilename())));
        result.setTargetHistoryToken(ImageOverviewHandler.token((AlbumImageId)i.getId()));
        return result;
    }

    protected void onLoad() {
        super.onLoad();
        this._eventManagerHelper.registerListener(ImageDeletedEvent.class, (EventListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void onUnload() {
        super.onUnload();
        this._eventManagerHelper.onUnloadRemoveHandlersFromManager();
    }
}

