/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.drive;

import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.events.PostCreatedEvent;
import de.justsoftware.news.events.PostDeletedEvent;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.kafka.drive.DriveCreateItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000fH\u0017R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/news/kafka/drive/KafkaDriveProducer;", "", "producer", "Lorg/apache/kafka/clients/producer/KafkaProducer;", "", "(Lorg/apache/kafka/clients/producer/KafkaProducer;)V", "deleteAllAttachments", "", "event", "Lde/justsoftware/news/events/PostDeletedEvent;", "publishPostItem", "post", "Lde/justsoftware/news/domain/post/Post;", "tenantId", "Lde/justsoftware/news/id/TenantId;", "Lde/justsoftware/news/events/PostCreatedEvent;", "news-service"})
public class KafkaDriveProducer {
    @NotNull
    private final KafkaProducer<String, String> producer;

    public KafkaDriveProducer(@NotNull KafkaProducer<String, String> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        this.producer = producer;
    }

    @Async
    @EventListener
    public void publishPostItem(@NotNull PostCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.publishPostItem(event.getPost(), event.getTenantId());
    }

    public void publishPostItem(@NotNull Post post, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DriveCreateItem item = new DriveCreateItem(post.getChannelId().toTypedString(), post.getTitle(), false, tenantId.toTypedString(), 4, null);
        String itemJson = ExtensionsKt.jacksonObjectMapper().writeValueAsString((Object)item);
        this.producer.send(new ProducerRecord("just.items", (Object)post.getId().toTypedString(), (Object)itemJson));
    }

    @Async
    @EventListener
    public void deleteAllAttachments(@NotNull PostDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.producer.send(new ProducerRecord("just.items", (Object)event.getPostId().toTypedString(), null));
    }
}

