/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.translation;

import de.justsoftware.news.connector.translation.TranslationException;
import de.justsoftware.news.domain.post.model.TranslationLanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n0\tH\u0012J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0012J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0007H\u0016J,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/justsoftware/news/connector/translation/TranslationConnector;", "", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "(Lorg/springframework/web/client/RestTemplate;)V", "extractTranslations", "", "", "deeplResponse", "Lorg/springframework/http/ResponseEntity;", "", "getHost", "deeplKey", "translateHtml", "html", "targetLanguage", "Lde/justsoftware/news/domain/post/model/TranslationLanguage;", "translateTexts", "texts", "news-service"})
@SourceDebugExtension(value={"SMAP\nTranslationConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationConnector.kt\nde/justsoftware/news/connector/translation/TranslationConnector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1#2:85\n1855#3,2:86\n1549#3:88\n1620#3,3:89\n*S KotlinDebug\n*F\n+ 1 TranslationConnector.kt\nde/justsoftware/news/connector/translation/TranslationConnector\n*L\n44#1:86,2\n70#1:88\n70#1:89,3\n*E\n"})
public class TranslationConnector {
    @NotNull
    private final RestTemplate restTemplate;

    public TranslationConnector(@NotNull RestTemplate restTemplate) {
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        this.restTemplate = restTemplate;
    }

    public /* synthetic */ TranslationConnector(RestTemplate restTemplate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            restTemplate = new RestTemplate();
        }
        this(restTemplate);
    }

    @NotNull
    public String translateHtml(@NotNull String html, @NotNull TranslationLanguage targetLanguage, @NotNull String deeplKey) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)deeplKey, (String)"deeplKey");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap body = (MultiValueMap)new LinkedMultiValueMap();
        body.add((Object)"text", (Object)html);
        body.add((Object)"target_lang", (Object)targetLanguage.name());
        body.add((Object)"preserve_formatting", (Object)"1");
        body.add((Object)"auth_key", (Object)deeplKey);
        body.add((Object)"tag_handling", (Object)"xml");
        ResponseEntity it = this.restTemplate.postForEntity(this.getHost(deeplKey), (Object)new HttpEntity((Object)body, (MultiValueMap)headers), Map.class, new Object[0]);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return (String)CollectionsKt.first((List)this.extractTranslations(it));
    }

    @NotNull
    public List<String> translateTexts(@NotNull List<String> texts, @NotNull TranslationLanguage targetLanguage, @NotNull String deeplKey) {
        Intrinsics.checkNotNullParameter(texts, (String)"texts");
        Intrinsics.checkNotNullParameter((Object)targetLanguage, (String)"targetLanguage");
        Intrinsics.checkNotNullParameter((Object)deeplKey, (String)"deeplKey");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap body = (MultiValueMap)new LinkedMultiValueMap();
        Iterable $this$forEach$iv = texts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            body.add((Object)"text", (Object)it);
        }
        body.add((Object)"target_lang", (Object)targetLanguage.name());
        body.add((Object)"preserve_formatting", (Object)"1");
        body.add((Object)"auth_key", (Object)deeplKey);
        body.add((Object)"split_sentences", (Object)"0");
        ResponseEntity it = this.restTemplate.postForEntity(this.getHost(deeplKey), (Object)new HttpEntity((Object)body, (MultiValueMap)headers), Map.class, new Object[0]);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        return this.extractTranslations(it);
    }

    /*
     * WARNING - void declaration
     */
    private List<String> extractTranslations(ResponseEntity<Map<?, ?>> deeplResponse) {
        void $this$mapTo$iv$iv;
        Map map;
        Map body = (Map)deeplResponse.getBody();
        if (deeplResponse.getStatusCode() != HttpStatus.OK || (map = body) == null || map.isEmpty()) {
            throw new TranslationException();
        }
        Object v = body.get("translations");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.Map<kotlin.String, kotlin.String>>");
        Iterable $this$map$iv = (List)v;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void translation;
            Map map2 = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = (String)translation.get("text");
            if (string == null) {
                throw new TranslationException();
            }
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    private String getHost(String deeplKey) {
        return StringsKt.endsWith$default((String)deeplKey, (String)":fx", (boolean)false, (int)2, null) ? "https://api-free.deepl.com/v2/translate" : "https://api.deepl.com/v2/translate";
    }

    public TranslationConnector() {
        this(null, 1, null);
    }
}

