/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.reaction;

import com.netflix.graphql.dgs.DgsDataLoader;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.reaction.ReactionService;
import de.justsoftware.news.id.LikeableId;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.MappedBatchLoaderWithContext;
import org.jetbrains.annotations.NotNull;

@DgsDataLoader(name="likedByItemId")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/news/domain/reaction/LikedDataLoader;", "Lorg/dataloader/MappedBatchLoaderWithContext;", "Lde/justsoftware/news/id/LikeableId;", "", "reactionService", "Lde/justsoftware/news/domain/reaction/ReactionService;", "(Lde/justsoftware/news/domain/reaction/ReactionService;)V", "load", "Ljava/util/concurrent/CompletionStage;", "", "ids", "", "ble", "Lorg/dataloader/BatchLoaderEnvironment;", "news-service"})
public class LikedDataLoader
implements MappedBatchLoaderWithContext<LikeableId, Boolean> {
    @NotNull
    private final ReactionService reactionService;

    public LikedDataLoader(@NotNull ReactionService reactionService) {
        Intrinsics.checkNotNullParameter((Object)reactionService, (String)"reactionService");
        this.reactionService = reactionService;
    }

    @NotNull
    public CompletionStage<Map<LikeableId, Boolean>> load(@NotNull Set<? extends LikeableId> ids, @NotNull BatchLoaderEnvironment ble) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)ble, (String)"ble");
        CompletableFuture<Map> completableFuture = CompletableFuture.supplyAsync(() -> LikedDataLoader.load$lambda$0(ble, this, ids));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private static final Map load$lambda$0(BatchLoaderEnvironment $ble, LikedDataLoader this$0, Set $ids) {
        Intrinsics.checkNotNullParameter((Object)$ble, (String)"$ble");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$ids, (String)"$ids");
        AuthorizationContext authCtx = (AuthorizationContext)DgsContext.Companion.getCustomContext($ble);
        return this$0.reactionService.getLikesForProfileByItemIds(authCtx.getUser(), (Collection)$ids);
    }
}

