/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.delete;

import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.connector.permission.PermissionItem;
import de.justsoftware.news.connector.permission.PermissionKafkaProducer;
import de.justsoftware.news.connector.superoperty.SuperopertyConnector;
import de.justsoftware.news.domain.channel.ChannelAction;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.channel.permission.ChannelPermission;
import de.justsoftware.news.domain.channel.permission.ChannelPermissionRepo;
import de.justsoftware.news.domain.channel.permission.PermissionRole;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.reaction.ReactionRepo;
import de.justsoftware.news.domain.subscription.managed.ManagedSubscriptionRepo;
import de.justsoftware.news.domain.subscription.personal.PersonalSubscriptionRepo;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.news.util.TransactionSupport;
import de.justsoftware.news.util.Unauthorized;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0017J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0017J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001fH\u0012J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010!\u001a\u00020\"H\u0017J\b\u0010'\u001a\u00020\u001aH\u0017J\u001e\u0010'\u001a\u00020\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010#\u001a\u00020\u0018H\u0012J\u0018\u0010+\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0018H\u0012R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lde/justsoftware/news/domain/delete/DeleteService;", "", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "personalSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;", "managedSubscriptionRepo", "Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;", "channelPermissionRepo", "Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "reactionRepo", "Lde/justsoftware/news/domain/reaction/ReactionRepo;", "transactionSupport", "Lde/justsoftware/news/util/TransactionSupport;", "permissionKafkaProducer", "Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "superopertyConnector", "Lde/justsoftware/news/connector/superoperty/SuperopertyConnector;", "(Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/domain/subscription/personal/PersonalSubscriptionRepo;Lde/justsoftware/news/domain/subscription/managed/ManagedSubscriptionRepo;Lde/justsoftware/news/domain/channel/permission/ChannelPermissionRepo;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/reaction/ReactionRepo;Lde/justsoftware/news/util/TransactionSupport;Lde/justsoftware/news/connector/permission/PermissionKafkaProducer;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/news/connector/superoperty/SuperopertyConnector;)V", "systemUser", "Lde/justsoftware/news/id/ProfileId;", "deleteChannelsAndPosts", "", "markAllChannelsAndPostsForDeletion", "tenantId", "Lde/justsoftware/news/id/TenantId;", "markChannelForDeletion", "Lde/justsoftware/news/id/ChannelId;", "channelId", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "user", "markPostForDeletion", "Lde/justsoftware/news/id/PostId;", "postId", "markPostsForDeletion", "posts", "", "Lde/justsoftware/news/domain/post/Post;", "markPostsForDeletionByChannel", "news-service"})
@SourceDebugExtension(value={"SMAP\nDeleteService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeleteService.kt\nde/justsoftware/news/domain/delete/DeleteService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1855#2,2:148\n1549#2:150\n1620#2,3:151\n1549#2:155\n1620#2,3:156\n1549#2:159\n1620#2,3:160\n1#3:154\n*S KotlinDebug\n*F\n+ 1 DeleteService.kt\nde/justsoftware/news/domain/delete/DeleteService\n*L\n74#1:148,2\n91#1:150\n91#1:151,3\n131#1:155\n131#1:156,3\n135#1:159\n135#1:160,3\n*E\n"})
public class DeleteService {
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final PersonalSubscriptionRepo personalSubscriptionRepo;
    @NotNull
    private final ManagedSubscriptionRepo managedSubscriptionRepo;
    @NotNull
    private final ChannelPermissionRepo channelPermissionRepo;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final ReactionRepo reactionRepo;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final PermissionKafkaProducer permissionKafkaProducer;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    @NotNull
    private final SuperopertyConnector superopertyConnector;
    @NotNull
    private final ProfileId systemUser;

    public DeleteService(@NotNull ChannelRepo channelRepo, @NotNull PersonalSubscriptionRepo personalSubscriptionRepo, @NotNull ManagedSubscriptionRepo managedSubscriptionRepo, @NotNull ChannelPermissionRepo channelPermissionRepo, @NotNull PostRepo postRepo, @NotNull ReactionRepo reactionRepo, @NotNull TransactionSupport transactionSupport, @NotNull PermissionKafkaProducer permissionKafkaProducer, @NotNull ApplicationEventPublisher eventPublisher, @NotNull SuperopertyConnector superopertyConnector) {
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)personalSubscriptionRepo, (String)"personalSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)managedSubscriptionRepo, (String)"managedSubscriptionRepo");
        Intrinsics.checkNotNullParameter((Object)channelPermissionRepo, (String)"channelPermissionRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)reactionRepo, (String)"reactionRepo");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)permissionKafkaProducer, (String)"permissionKafkaProducer");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)superopertyConnector, (String)"superopertyConnector");
        this.channelRepo = channelRepo;
        this.personalSubscriptionRepo = personalSubscriptionRepo;
        this.managedSubscriptionRepo = managedSubscriptionRepo;
        this.channelPermissionRepo = channelPermissionRepo;
        this.postRepo = postRepo;
        this.reactionRepo = reactionRepo;
        this.transactionSupport = transactionSupport;
        this.permissionKafkaProducer = permissionKafkaProducer;
        this.eventPublisher = eventPublisher;
        this.superopertyConnector = superopertyConnector;
        this.systemUser = ProfileId.Companion.fromValue(-1L);
    }

    @Transactional
    public void deleteChannelsAndPosts() {
        Instant deleteOlderThan = Instant.now().minus(this.superopertyConnector.getDeletionDelay());
        Intrinsics.checkNotNull((Object)deleteOlderThan);
        this.channelRepo.deleteMarked(deleteOlderThan);
        Set it = this.postRepo.findPostIdsToDelete(deleteOlderThan);
        boolean bl = false;
        if (!((Collection)it).isEmpty()) {
            this.reactionRepo.deleteByItemIdsIn((Collection)it);
            this.postRepo.deleteAllById((Iterable)it);
        }
    }

    @Unauthorized
    @Transactional
    public void markAllChannelsAndPostsForDeletion(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        List channelIds = this.channelRepo.getIdsByTenant(tenantId);
        Iterable $this$forEach$iv = channelIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChannelId it = (ChannelId)element$iv;
            boolean bl = false;
            this.markChannelForDeletion(this.systemUser, it);
        }
    }

    @Transactional
    @NotNull
    public ChannelId markChannelForDeletion(@NotNull ChannelId channelId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkChannelAction(channelId, ChannelAction.DELETE);
        return this.markChannelForDeletion(authContext.getUser(), channelId);
    }

    /*
     * WARNING - void declaration
     */
    private ChannelId markChannelForDeletion(ProfileId user, ChannelId channelId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.channelRepo.updateDeleted(channelId, true, user, instant);
        this.personalSubscriptionRepo.deleteByChannelId(channelId);
        this.managedSubscriptionRepo.deleteByChannelId(channelId);
        this.markPostsForDeletionByChannel(channelId, user);
        Iterable iterable = this.channelPermissionRepo.findAllByChannelId(channelId);
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChannelPermission channelPermission = (ChannelPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PermissionItem((ItemId)it.getId(), it.getGranteeId(), it.getRole()));
        }
        List channelPermissions = (List)destination$iv$iv;
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return channelId;
    }

    @Transactional
    @NotNull
    public PostId markPostForDeletion(@NotNull PostId postId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.postRepo.findById((Object)postId).ifPresent(arg_0 -> DeleteService.markPostForDeletion$lambda$3((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        return postId;
    }

    private void markPostsForDeletionByChannel(ChannelId channelId, ProfileId user) {
        Collection collection = this.postRepo.findByChannelIdAndDeletedFalse(channelId);
        if (collection.isEmpty()) {
            boolean bl = false;
            return;
        }
        Set posts2 = (Set)collection;
        this.markPostsForDeletion((Collection)posts2, user);
    }

    @Unauthorized
    public void markPostsForDeletion() {
        Set it = PostRepo.getByDeletedFalseAndDeleteDateLessThanEqual$default((PostRepo)this.postRepo, null, (int)1, null);
        boolean bl = false;
        this.markPostsForDeletion((Collection)it, this.systemUser);
    }

    /*
     * WARNING - void declaration
     */
    private void markPostsForDeletion(Collection<Post> posts2, ProfileId user) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (posts2.isEmpty()) {
            return;
        }
        Set uniquePosts = CollectionsKt.toSet((Iterable)posts2);
        Iterable $this$map$iv = uniquePosts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Post post = (Post)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set postIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.postRepo.updateDeletedByIds(postIds, true, user, instant);
        Iterable $this$map$iv2 = uniquePosts;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post bl = (Post)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            void it2 = it;
            boolean bl3 = false;
            collection.add(new PermissionItem((ItemId)it2.getId(), (UserId)it2.getAuthorId(), PermissionRole.MANAGER));
        }
        List postPermissions = (List)destination$iv$iv2;
        this.transactionSupport.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static final void markPostForDeletion$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ PermissionKafkaProducer access$getPermissionKafkaProducer$p(DeleteService $this) {
        return $this.permissionKafkaProducer;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getEventPublisher$p(DeleteService $this) {
        return $this.eventPublisher;
    }

    public static final /* synthetic */ void access$markPostsForDeletion(DeleteService $this, Collection posts2, ProfileId user) {
        $this.markPostsForDeletion(posts2, user);
    }
}

