/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.notification.service;

import de.justsoftware.mobile.gateway.notification.model.MobilePushToken;
import de.justsoftware.mobile.gateway.notification.model.Notification;
import de.justsoftware.mobile.gateway.notification.model.NotificationsCount;
import de.justsoftware.mobile.gateway.notification.service.NotificationApiGatewayService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\u0016\u0010\u0016\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/mobile/gateway/notification/service/NotificationService;", "", "notificationApiGatewayService", "Lde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService;", "(Lde/justsoftware/mobile/gateway/notification/service/NotificationApiGatewayService;)V", "archiveAllNotifications", "", "", "archiveNotification", "", "notificationId", "getNotifications", "Lde/justsoftware/mobile/gateway/notification/model/Notification;", "state", "limit", "", "date", "locale", "getNotificationsCount", "Lde/justsoftware/mobile/gateway/notification/model/NotificationsCount;", "markNotification", "action", "openNotifications", "notificationIds", "registerAndroid", "Lde/justsoftware/mobile/gateway/notification/model/MobilePushToken;", "pushToken", "registerIos", "silenceAlerts", "", "unregisterPushToken", "platform", "mobile-gateway"})
public class NotificationService {
    @NotNull
    private final NotificationApiGatewayService notificationApiGatewayService;

    public NotificationService(@NotNull NotificationApiGatewayService notificationApiGatewayService) {
        Intrinsics.checkNotNullParameter((Object)notificationApiGatewayService, (String)"notificationApiGatewayService");
        this.notificationApiGatewayService = notificationApiGatewayService;
    }

    @NotNull
    public List<Notification> getNotifications(@NotNull String state, int limit, @NotNull String date, @NotNull String locale) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        return this.notificationApiGatewayService.getNotifications(state, limit, date, locale);
    }

    @NotNull
    public NotificationsCount getNotificationsCount() {
        return this.notificationApiGatewayService.getNotificationsCount();
    }

    @NotNull
    public List<String> archiveAllNotifications() {
        return this.notificationApiGatewayService.archiveAllNotifications();
    }

    public void archiveNotification(@NotNull String notificationId) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        this.notificationApiGatewayService.archiveNotification(notificationId);
    }

    public void openNotifications(@NotNull List<String> notificationIds) {
        Intrinsics.checkNotNullParameter(notificationIds, (String)"notificationIds");
        this.notificationApiGatewayService.openNotifications(notificationIds);
    }

    public void markNotification(@NotNull String notificationId, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this.notificationApiGatewayService.markNotification(notificationId, action);
    }

    @NotNull
    public MobilePushToken registerAndroid(@NotNull String pushToken) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        return this.notificationApiGatewayService.registerAndroid(pushToken);
    }

    @NotNull
    public MobilePushToken registerIos(@NotNull String pushToken, boolean silenceAlerts) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        return this.notificationApiGatewayService.registerIos(pushToken, silenceAlerts);
    }

    public void unregisterPushToken(@NotNull String platform, @NotNull String pushToken) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        this.notificationApiGatewayService.unregisterPushToken(platform, pushToken);
    }
}

